/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.LoadableSchemaObject;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.SyntaxChecker;

public final class DescriptionUtils {
    private DescriptionUtils() {
    }

    public static String getDescription(LdapComparator<?> comparator) {
        return DescriptionUtils.getLoadableDescription(comparator);
    }

    public static String getDescription(Normalizer normalizer) {
        return DescriptionUtils.getLoadableDescription(normalizer);
    }

    public static String getDescription(SyntaxChecker syntaxChecker) {
        return DescriptionUtils.getLoadableDescription(syntaxChecker);
    }

    private static void getExtensions(StringBuilder sb, Map<String, List<String>> extensions) {
        for (Map.Entry<String, List<String>> extension : extensions.entrySet()) {
            sb.append(' ').append(extension.getKey()).append(' ');
            List<String> values = extension.getValue();
            if (values != null && !values.isEmpty()) {
                if (values.size() == 1) {
                    sb.append(values.get(0));
                } else {
                    boolean isFirst = true;
                    sb.append("( ");
                    for (String value : values) {
                        if (isFirst) {
                            isFirst = false;
                        } else {
                            sb.append(' ');
                        }
                        sb.append(value);
                    }
                    sb.append(" )");
                }
            }
            sb.append('\n');
        }
    }

    private static String getLoadableDescription(LoadableSchemaObject schemaObject) {
        StringBuilder buf = new StringBuilder("( ");
        buf.append(schemaObject.getOid());
        buf.append('\n');
        if (schemaObject.getDescription() != null) {
            buf.append(" DESC ");
            buf.append(schemaObject.getDescription());
            buf.append('\n');
        }
        if (schemaObject.getFqcn() != null) {
            buf.append(" FQCN ");
            buf.append(schemaObject.getFqcn());
            buf.append('\n');
        }
        if (schemaObject.getBytecode() != null) {
            buf.append(" BYTECODE ");
            if (schemaObject.getBytecode().length() > 16) {
                buf.append(schemaObject.getBytecode().substring(0, 16));
            } else {
                buf.append(schemaObject.getBytecode());
            }
            buf.append('\n');
        }
        if (schemaObject.getExtensions() != null) {
            DescriptionUtils.getExtensions(buf, schemaObject.getExtensions());
        }
        buf.append(" ) ");
        return buf.toString();
    }
}

