/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.extended;

import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.CompareResponseImpl;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;

public final class CompareNoDResponse
extends CompareResponseImpl {
    public static final String EXTENSION_OID = "1.3.6.1.4.1.1466.20036";
    public static final CompareNoDResponse UNAVAILABLE = new CompareNoDResponse(ResultCodeEnum.UNAVAILABLE);
    public static final CompareNoDResponse PROTOCOLERROR = new CompareNoDResponse(ResultCodeEnum.PROTOCOL_ERROR);
    public static final CompareNoDResponse STRONGAUTHREQUIRED = new CompareNoDResponse(ResultCodeEnum.STRONG_AUTH_REQUIRED);

    private CompareNoDResponse(ResultCodeEnum rcode) {
        switch (rcode) {
            case UNAVAILABLE: {
                break;
            }
            case PROTOCOL_ERROR: {
                break;
            }
            case STRONG_AUTH_REQUIRED: {
                break;
            }
            default: {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_13503_RESULT_CODE_SHOULD_BE_IN, new Object[]{ResultCodeEnum.UNAVAILABLE, ResultCodeEnum.PROTOCOL_ERROR, ResultCodeEnum.STRONG_AUTH_REQUIRED}));
            }
        }
        super.getLdapResult().setDiagnosticMessage(rcode.toString() + ": The server will disconnect!");
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(rcode);
    }

    public byte[] getResponse() {
        return Strings.EMPTY_BYTES;
    }

    public String getResponseName() {
        return EXTENSION_OID;
    }
}

