/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.controls.vlv_impl;

import org.apache.hadoop.shaded.org.apache.directory.api.asn1.DecoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.AbstractControlFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.controls.vlv.VirtualListViewRequest;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.controls.vlv.VirtualListViewRequestImpl;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.controls.vlv_impl.VirtualListViewRequestContainer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.controls.vlv_impl.VirtualListViewerTags;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.Control;

public class VirtualListViewRequestFactory
extends AbstractControlFactory<VirtualListViewRequest> {
    public VirtualListViewRequestFactory(LdapApiService codec) {
        super(codec, "2.16.840.1.113730.3.4.9");
    }

    @Override
    public VirtualListViewRequest newControl() {
        return new VirtualListViewRequestImpl();
    }

    @Override
    public void encodeValue(Asn1Buffer buffer, Control control) {
        int start = buffer.getPos();
        VirtualListViewRequest vlvRequest = (VirtualListViewRequest)control;
        if (vlvRequest.getContextId() != null) {
            BerValue.encodeOctetString(buffer, vlvRequest.getContextId());
        }
        if (vlvRequest.hasOffset()) {
            int offsetStart = buffer.getPos();
            BerValue.encodeInteger(buffer, vlvRequest.getContentCount());
            BerValue.encodeInteger(buffer, vlvRequest.getOffset());
            BerValue.encodeSequence(buffer, (byte)VirtualListViewerTags.BY_OFFSET_TAG.getValue(), offsetStart);
        } else {
            BerValue.encodeOctetString(buffer, (byte)VirtualListViewerTags.ASSERTION_VALUE_TAG.getValue(), vlvRequest.getAssertionValue());
        }
        BerValue.encodeInteger(buffer, vlvRequest.getAfterCount());
        BerValue.encodeInteger(buffer, vlvRequest.getBeforeCount());
        BerValue.encodeSequence(buffer, start);
    }

    @Override
    public void decodeValue(Control control, byte[] controlBytes) throws DecoderException {
        this.decodeValue(new VirtualListViewRequestContainer(control), control, controlBytes);
    }
}

