/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api;

import java.nio.ByteBuffer;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.DecoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.ControlContainer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.ControlFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.Control;

public abstract class AbstractControlFactory<C extends Control>
implements ControlFactory<C> {
    protected LdapApiService codec;
    protected String oid;

    protected AbstractControlFactory(LdapApiService codec, String oid) {
        this.codec = codec;
        this.oid = oid;
    }

    @Override
    public String getOid() {
        return this.oid;
    }

    @Override
    public void encodeValue(Asn1Buffer buffer, Control control) {
    }

    @Override
    public void decodeValue(Control control, byte[] controlBytes) throws DecoderException {
    }

    @Override
    public void decodeValue(ControlContainer container, Control control, byte[] controlBytes) throws DecoderException {
        ByteBuffer buffer = ByteBuffer.wrap(controlBytes);
        container.setControl(control);
        Asn1Decoder.decode(buffer, container);
    }
}

