/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.actions.request.unbind;

import org.apache.hadoop.shaded.org.apache.directory.api.asn1.DecoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.UnbindRequest;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.UnbindRequestImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitUnbindRequest
extends GrammarAction<LdapMessageContainer<UnbindRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitUnbindRequest.class);

    public InitUnbindRequest() {
        super("Unbind Request initialization");
    }

    @Override
    public void action(LdapMessageContainer<UnbindRequest> container) throws DecoderException {
        UnbindRequestImpl unbindRequest = new UnbindRequestImpl();
        unbindRequest.setMessageId(container.getMessageId());
        container.setMessage(unbindRequest);
        TLV tlv = container.getCurrentTLV();
        int expectedLength = tlv.getLength();
        if (expectedLength != 0) {
            LOG.error(I18n.err(I18n.ERR_05130_NON_NULL_UNBIND_LENGTH, expectedLength));
            throw new DecoderException(I18n.err(I18n.ERR_05131_UNBIND_REQUEST_LENGTH_MUST_BE_NULL, new Object[0]));
        }
        container.setGrammarEndAllowed(true);
    }
}

