/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.actions.request.search.filter;

import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.search.ExtensibleMatchFilter;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.entry.Value;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreMatchValue
extends GrammarAction<LdapMessageContainer<SearchRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreMatchValue.class);

    public StoreMatchValue() {
        super("Store match Value");
    }

    @Override
    public void action(LdapMessageContainer<SearchRequest> container) {
        TLV tlv = container.getCurrentTLV();
        ExtensibleMatchFilter extensibleMatchFilter = (ExtensibleMatchFilter)container.getTerminalFilter();
        byte[] value = tlv.getValue().getData();
        extensibleMatchFilter.setMatchValue(new Value(value));
        container.unstackFilters();
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_05156_STORED_MATCH_VALUE, new Object[]{value}));
        }
    }
}

