/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.actions.request.search;

import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreSearchRequestAttributeDesc
extends GrammarAction<LdapMessageContainer<SearchRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSearchRequestAttributeDesc.class);

    public StoreSearchRequestAttributeDesc() {
        super("Store attribute description");
    }

    @Override
    public void action(LdapMessageContainer<SearchRequest> container) {
        SearchRequest searchRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        String attributeDescription = null;
        if (tlv.getLength() != 0 && !Strings.isEmpty((attributeDescription = Strings.utf8ToString(tlv.getValue().getData())).trim())) {
            searchRequest.addAttributes(attributeDescription);
        }
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_05159_DECODED_ATT_DESC, attributeDescription));
        }
    }
}

