/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.actions.request.search;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.DecoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.AttributeValueAssertion;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.search.AndFilter;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.search.AttributeValueAssertionFilter;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.search.ConnectorFilter;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.search.ExtensibleMatchFilter;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.search.Filter;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.search.OrFilter;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.search.PresentFilter;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.search.SubstringFilter;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.entry.Value;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.exception.LdapSchemaException;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.filter.AndNode;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.filter.ApproximateNode;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.filter.BranchNode;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.filter.ExtensibleNode;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.filter.GreaterEqNode;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.filter.LeafNode;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.filter.LessEqNode;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.filter.NotNode;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.filter.OrNode;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.filter.SubstringNode;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitSearchRequestAttributeDescList
extends GrammarAction<LdapMessageContainer<SearchRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitSearchRequestAttributeDescList.class);

    public InitSearchRequestAttributeDescList() {
        super("Initialize AttributeDesc list");
    }

    private ExprNode transform(Filter filter) throws LdapSchemaException {
        if (filter != null) {
            if (filter instanceof ConnectorFilter) {
                BranchNode branch = filter instanceof AndFilter ? new AndNode() : (filter instanceof OrFilter ? new OrNode() : new NotNode());
                List<Filter> filtersSet = ((ConnectorFilter)filter).getFilterSet();
                if (filtersSet != null) {
                    for (Filter node : filtersSet) {
                        branch.addNode(this.transform(node));
                    }
                }
                return branch;
            }
            LeafNode branch = null;
            if (filter instanceof PresentFilter) {
                branch = new PresenceNode(((PresentFilter)filter).getAttributeDescription());
            } else if (filter instanceof AttributeValueAssertionFilter) {
                AttributeValueAssertion ava = ((AttributeValueAssertionFilter)filter).getAssertion();
                int filterType = ((AttributeValueAssertionFilter)filter).getFilterType();
                switch (filterType) {
                    case 0: {
                        branch = new EqualityNode(ava.getAttributeDesc(), ava.getAssertion());
                        break;
                    }
                    case 1: {
                        branch = new GreaterEqNode(ava.getAttributeDesc(), ava.getAssertion());
                        break;
                    }
                    case 2: {
                        branch = new LessEqNode(ava.getAttributeDesc(), ava.getAssertion());
                        break;
                    }
                    case 3: {
                        branch = new ApproximateNode(ava.getAttributeDesc(), ava.getAssertion());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(I18n.err(I18n.ERR_05503_UNEXPECTED_FILTER_TYPE, filterType));
                    }
                }
            } else if (filter instanceof SubstringFilter) {
                SubstringFilter substrFilter = (SubstringFilter)filter;
                String initialString = null;
                String finalString = null;
                ArrayList<String> anyString = null;
                if (substrFilter.getInitialSubstrings() != null) {
                    initialString = substrFilter.getInitialSubstrings();
                }
                if (substrFilter.getFinalSubstrings() != null) {
                    finalString = substrFilter.getFinalSubstrings();
                }
                if (substrFilter.getAnySubstrings() != null) {
                    anyString = new ArrayList<String>();
                    for (String any : substrFilter.getAnySubstrings()) {
                        anyString.add(any);
                    }
                }
                branch = new SubstringNode(anyString, substrFilter.getType(), initialString, finalString);
            } else if (filter instanceof ExtensibleMatchFilter) {
                ExtensibleMatchFilter extFilter = (ExtensibleMatchFilter)filter;
                String matchingRule = null;
                Value value = extFilter.getMatchValue();
                if (extFilter.getMatchingRule() != null) {
                    matchingRule = extFilter.getMatchingRule();
                }
                branch = new ExtensibleNode(extFilter.getType(), value, matchingRule, extFilter.isDnAttributes());
            }
            return branch;
        }
        return null;
    }

    @Override
    public void action(LdapMessageContainer<SearchRequest> container) throws DecoderException {
        SearchRequest searchRequest = container.getMessage();
        try {
            searchRequest.setFilter(this.transform(container.getTopFilter()));
        }
        catch (LdapSchemaException lse) {
            throw new DecoderException(lse.getMessage(), lse);
        }
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_05158_INITIALIZE_ATT_DESC_LIST, new Object[0]));
        }
    }
}

