/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.actions.request.add;

import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.AddRequest;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddAttributeValue
extends GrammarAction<LdapMessageContainer<AddRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(AddAttributeValue.class);

    public AddAttributeValue() {
        super("Store a value");
    }

    @Override
    public void action(LdapMessageContainer<AddRequest> container) {
        Attribute currentAttribute = container.getCurrentAttribute();
        TLV tlv = container.getCurrentTLV();
        Object value = null;
        try {
            if (tlv.getLength() == 0) {
                currentAttribute.add("");
            } else if (container.isBinary(currentAttribute.getId())) {
                value = tlv.getValue().getData();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_05112_ADDING_VALUE, Strings.dumpBytes(value)));
                }
                currentAttribute.add(new byte[][]{value});
            } else {
                value = Strings.utf8ToString(tlv.getValue().getData());
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_05112_ADDING_VALUE, value));
                }
                currentAttribute.add((String)value);
            }
        }
        catch (LdapException ldapException) {
            // empty catch block
        }
        container.setGrammarEndAllowed(true);
    }
}

