/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.actions.ldapResult;

import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.Message;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreErrorMessage
extends GrammarAction<LdapMessageContainer<Message>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreErrorMessage.class);

    public StoreErrorMessage() {
        super("Store error message");
    }

    @Override
    public void action(LdapMessageContainer<Message> container) {
        TLV tlv = container.getCurrentTLV();
        String errorMessage = tlv.getLength() == 0 ? "" : Strings.utf8ToString(tlv.getValue().getData());
        LdapResult ldapResult = container.getLdapResult();
        ldapResult.setDiagnosticMessage(errorMessage);
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_05106_ERROR_MESSAGE_IS, errorMessage));
        }
    }
}

