/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.asn1.util;

import java.nio.ByteBuffer;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.util.Asn1StringUtils;

public class Asn1Buffer {
    private static final int DEFAULT_SIZE = 1024;
    private int pos = 0;
    private byte[] buffer = new byte[1024];

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public void put(byte b) {
        if (this.pos == this.buffer.length) {
            this.extend(1);
        }
        ++this.pos;
        this.buffer[this.buffer.length - this.pos] = b;
    }

    public void put(byte[] bytes) {
        if (this.pos + bytes.length > this.buffer.length) {
            this.extend(bytes.length);
        }
        this.pos += bytes.length;
        System.arraycopy(bytes, 0, this.buffer, this.buffer.length - this.pos, bytes.length);
    }

    private void extend(int size) {
        int newSize = (size + this.buffer.length) / 1024 * 1024;
        if (size % 1024 != 0) {
            newSize += 1024;
        }
        byte[] newBuffer = new byte[newSize];
        System.arraycopy(this.buffer, 0, newBuffer, newSize - this.buffer.length, this.buffer.length);
        this.buffer = newBuffer;
    }

    public ByteBuffer getBytes() {
        ByteBuffer result = ByteBuffer.allocate(this.pos);
        result.put(this.buffer, this.buffer.length - this.pos, this.pos);
        result.flip();
        return result;
    }

    public int getSize() {
        return this.buffer.length;
    }

    public void clear() {
        if (this.buffer.length > 1024) {
            this.buffer = new byte[1024];
        }
        this.pos = 0;
    }

    public String toString() {
        return "[" + this.buffer.length + ", " + this.pos + "] '" + Asn1StringUtils.dumpBytes(this.buffer, this.buffer.length - this.pos, this.pos) + '\'';
    }
}

