/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.mina.transport.vmpipe;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.shaded.org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.hadoop.shaded.org.apache.mina.core.service.DefaultTransportMetadata;
import org.apache.hadoop.shaded.org.apache.mina.core.service.IoHandler;
import org.apache.hadoop.shaded.org.apache.mina.core.service.IoProcessor;
import org.apache.hadoop.shaded.org.apache.mina.core.service.IoService;
import org.apache.hadoop.shaded.org.apache.mina.core.service.IoServiceListenerSupport;
import org.apache.hadoop.shaded.org.apache.mina.core.service.TransportMetadata;
import org.apache.hadoop.shaded.org.apache.mina.core.session.AbstractIoSession;
import org.apache.hadoop.shaded.org.apache.mina.core.write.WriteRequestQueue;
import org.apache.hadoop.shaded.org.apache.mina.transport.vmpipe.DefaultVmPipeSessionConfig;
import org.apache.hadoop.shaded.org.apache.mina.transport.vmpipe.VmPipe;
import org.apache.hadoop.shaded.org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.hadoop.shaded.org.apache.mina.transport.vmpipe.VmPipeFilterChain;
import org.apache.hadoop.shaded.org.apache.mina.transport.vmpipe.VmPipeSessionConfig;

class VmPipeSession
extends AbstractIoSession {
    static final TransportMetadata METADATA = new DefaultTransportMetadata("mina", "vmpipe", false, false, VmPipeAddress.class, VmPipeSessionConfig.class, Object.class);
    private final IoServiceListenerSupport serviceListeners;
    private final VmPipeAddress localAddress;
    private final VmPipeAddress remoteAddress;
    private final VmPipeAddress serviceAddress;
    private final VmPipeFilterChain filterChain;
    private final VmPipeSession remoteSession;
    private final Lock lock;
    final BlockingQueue<Object> receivedMessageQueue;

    VmPipeSession(IoService service, IoServiceListenerSupport serviceListeners, VmPipeAddress localAddress, IoHandler handler, VmPipe remoteEntry) {
        super(service);
        this.config = new DefaultVmPipeSessionConfig();
        this.serviceListeners = serviceListeners;
        this.lock = new ReentrantLock();
        this.localAddress = localAddress;
        this.remoteAddress = this.serviceAddress = remoteEntry.getAddress();
        this.filterChain = new VmPipeFilterChain(this);
        this.receivedMessageQueue = new LinkedBlockingQueue<Object>();
        this.remoteSession = new VmPipeSession(this, remoteEntry);
    }

    private VmPipeSession(VmPipeSession remoteSession, VmPipe entry) {
        super(entry.getAcceptor());
        this.config = new DefaultVmPipeSessionConfig();
        this.serviceListeners = entry.getListeners();
        this.lock = remoteSession.lock;
        this.localAddress = this.serviceAddress = remoteSession.remoteAddress;
        this.remoteAddress = remoteSession.localAddress;
        this.filterChain = new VmPipeFilterChain(this);
        this.remoteSession = remoteSession;
        this.receivedMessageQueue = new LinkedBlockingQueue<Object>();
    }

    @Override
    public IoProcessor<VmPipeSession> getProcessor() {
        return this.filterChain.getProcessor();
    }

    IoServiceListenerSupport getServiceListeners() {
        return this.serviceListeners;
    }

    @Override
    public VmPipeSessionConfig getConfig() {
        return (VmPipeSessionConfig)this.config;
    }

    @Override
    public IoFilterChain getFilterChain() {
        return this.filterChain;
    }

    public VmPipeSession getRemoteSession() {
        return this.remoteSession;
    }

    @Override
    public TransportMetadata getTransportMetadata() {
        return METADATA;
    }

    @Override
    public VmPipeAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public VmPipeAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public VmPipeAddress getServiceAddress() {
        return this.serviceAddress;
    }

    void increaseWrittenBytes0(int increment, long currentTime) {
        super.increaseWrittenBytes(increment, currentTime);
    }

    WriteRequestQueue getWriteRequestQueue0() {
        return super.getWriteRequestQueue();
    }

    Lock getLock() {
        return this.lock;
    }
}

