/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.kerberos.provider.token;

import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import org.apache.hadoop.shaded.com.nimbusds.jose.EncryptionMethod;
import org.apache.hadoop.shaded.com.nimbusds.jose.JOSEException;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEAlgorithm;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEEncrypter;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEHeader;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEObject;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWSAlgorithm;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWSHeader;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWSSigner;
import org.apache.hadoop.shaded.com.nimbusds.jose.KeyLengthException;
import org.apache.hadoop.shaded.com.nimbusds.jose.Payload;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.DirectEncrypter;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.ECDSASigner;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.MACSigner;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.RSAEncrypter;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.RSASSASigner;
import org.apache.hadoop.shaded.com.nimbusds.jwt.EncryptedJWT;
import org.apache.hadoop.shaded.com.nimbusds.jwt.JWT;
import org.apache.hadoop.shaded.com.nimbusds.jwt.SignedJWT;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.provider.TokenEncoder;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.AuthToken;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.provider.token.JwtAuthToken;

public class JwtTokenEncoder
implements TokenEncoder {
    private JWEAlgorithm jweAlgorithm = JWEAlgorithm.RSA_OAEP_256;
    private EncryptionMethod encryptionMethod = EncryptionMethod.A128GCM;
    private JWSAlgorithm jwsAlgorithm = JWSAlgorithm.RS256;
    private Object encryptionKey;
    private Object signKey;

    @Override
    public byte[] encodeAsBytes(AuthToken token) throws KrbException {
        String tokenStr = this.encodeAsString(token);
        return tokenStr.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public String encodeAsString(AuthToken token) throws KrbException {
        if (!(token instanceof JwtAuthToken)) {
            throw new KrbException("Unexpected AuthToken, not JwtAuthToken");
        }
        JwtAuthToken jwtAuthToken = (JwtAuthToken)token;
        JWT jwt = jwtAuthToken.getJwt();
        String tokenStr = null;
        if (this.signKey != null) {
            JWSSigner signer = this.createSigner();
            SignedJWT signedJWT = null;
            try {
                signedJWT = new SignedJWT(new JWSHeader(this.jwsAlgorithm), jwt.getJWTClaimsSet());
            }
            catch (ParseException e) {
                throw new KrbException("Failed to get JWT claims set", (Throwable)e);
            }
            try {
                signedJWT.sign(signer);
            }
            catch (JOSEException e) {
                throw new KrbException("Failed to sign the Signed JWT", (Throwable)e);
            }
            if (this.encryptionKey != null) {
                JWEObject jweObject = new JWEObject(new JWEHeader.Builder(this.jweAlgorithm, this.encryptionMethod).contentType("JWT").build(), new Payload(signedJWT));
                try {
                    jweObject.encrypt(this.createEncryptor());
                }
                catch (JOSEException e) {
                    throw new KrbException("Failed to encrypt the JWE object", (Throwable)e);
                }
                tokenStr = jweObject.serialize();
            } else {
                tokenStr = signedJWT.serialize();
            }
        } else if (this.encryptionKey != null) {
            JWEHeader header = new JWEHeader(this.jweAlgorithm, this.encryptionMethod);
            EncryptedJWT encryptedJWT = null;
            try {
                encryptedJWT = new EncryptedJWT(header, jwt.getJWTClaimsSet());
            }
            catch (ParseException e) {
                throw new KrbException("Failed to get JWT claims set", (Throwable)e);
            }
            try {
                encryptedJWT.encrypt(this.createEncryptor());
            }
            catch (JOSEException e) {
                throw new KrbException("Failed to encrypt the encrypted JWT", (Throwable)e);
            }
            tokenStr = encryptedJWT.serialize();
        } else {
            tokenStr = jwt.serialize();
        }
        return tokenStr;
    }

    private JWSSigner createSigner() throws KrbException {
        if (RSASSASigner.SUPPORTED_ALGORITHMS.contains(this.jwsAlgorithm)) {
            if (!(this.signKey instanceof RSAPrivateKey)) {
                throw new KrbException("An RSAPrivateKey key must be specified for signature");
            }
            return new RSASSASigner((RSAPrivateKey)this.signKey);
        }
        if (ECDSASigner.SUPPORTED_ALGORITHMS.contains(this.jwsAlgorithm)) {
            if (!(this.signKey instanceof ECPrivateKey)) {
                throw new KrbException("A ECPrivateKey key must be specified for signature");
            }
            try {
                return new ECDSASigner((ECPrivateKey)this.signKey);
            }
            catch (JOSEException e) {
                throw new KrbException(e.getMessage(), (Throwable)e);
            }
        }
        if (MACSigner.SUPPORTED_ALGORITHMS.contains(this.jwsAlgorithm)) {
            if (!(this.signKey instanceof byte[])) {
                throw new KrbException("A byte[] key must be specified for signature");
            }
            try {
                return new MACSigner((byte[])this.signKey);
            }
            catch (KeyLengthException e) {
                throw new KrbException(e.getMessage(), (Throwable)e);
            }
        }
        throw new KrbException("An unknown signature algorithm was specified");
    }

    private JWEEncrypter createEncryptor() throws KrbException, JOSEException {
        if (RSAEncrypter.SUPPORTED_ALGORITHMS.contains(this.jweAlgorithm)) {
            if (!(this.encryptionKey instanceof RSAPublicKey)) {
                throw new KrbException("An RSAPublicKey key must be specified for encryption");
            }
            return new RSAEncrypter((RSAPublicKey)this.encryptionKey);
        }
        if (DirectEncrypter.SUPPORTED_ALGORITHMS.contains(this.jweAlgorithm)) {
            if (!(this.encryptionKey instanceof byte[])) {
                throw new KrbException("A byte[] key must be specified for encryption");
            }
            return new DirectEncrypter((byte[])this.encryptionKey);
        }
        throw new KrbException("An unknown encryption algorithm was specified");
    }

    @Override
    public void setEncryptionKey(PublicKey key) {
        this.encryptionKey = key;
    }

    @Override
    public void setEncryptionKey(byte[] key) {
        this.encryptionKey = key == null ? (Object)new byte[0] : key.clone();
    }

    @Override
    public void setSignKey(PrivateKey key) {
        this.signKey = key;
    }

    @Override
    public void setSignKey(byte[] key) {
        this.signKey = key == null ? (Object)new byte[0] : key.clone();
    }

    public JWEAlgorithm getJweAlgorithm() {
        return this.jweAlgorithm;
    }

    public void setJweAlgorithm(JWEAlgorithm jweAlgorithm) {
        this.jweAlgorithm = jweAlgorithm;
    }

    public JWSAlgorithm getJwsAlgorithm() {
        return this.jwsAlgorithm;
    }

    public void setJwsAlgorithm(JWSAlgorithm jwsAlgorithm) {
        this.jwsAlgorithm = jwsAlgorithm;
    }

    public EncryptionMethod getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public void setEncryptionMethod(EncryptionMethod encryptionMethod) {
        this.encryptionMethod = encryptionMethod;
    }
}

