/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class Unicode {
    private static final int UTF8_MULTI_BYTES_MASK = 128;
    private static final int UTF8_TWO_BYTES_MASK = 224;
    private static final int UTF8_TWO_BYTES = 192;
    private static final int UTF8_THREE_BYTES_MASK = 240;
    private static final int UTF8_THREE_BYTES = 224;
    private static final int UTF8_FOUR_BYTES_MASK = 248;
    private static final int UTF8_FOUR_BYTES = 240;
    private static final int UTF8_FIVE_BYTES_MASK = 252;
    private static final int UTF8_FIVE_BYTES = 248;
    private static final int UTF8_SIX_BYTES_MASK = 254;
    private static final int UTF8_SIX_BYTES = 252;
    private static final boolean[] UNICODE_SUBSET = new boolean[]{false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private static final int CHAR_ONE_BYTE_MASK = -128;
    private static final int CHAR_TWO_BYTES_MASK = -2048;
    private static final int CHAR_THREE_BYTES_MASK = -65536;
    private static final int CHAR_FOUR_BYTES_MASK = -2097152;

    private Unicode() {
    }

    public static int countBytesPerChar(byte[] bytes, int pos) {
        if (bytes == null) {
            return -1;
        }
        if ((bytes[pos] & 0x80) == 0) {
            return 1;
        }
        if ((bytes[pos] & 0xE0) == 192) {
            return 2;
        }
        if ((bytes[pos] & 0xF0) == 224) {
            return 3;
        }
        if ((bytes[pos] & 0xF8) == 240) {
            return 4;
        }
        if ((bytes[pos] & 0xFC) == 248) {
            return 5;
        }
        if ((bytes[pos] & 0xFE) == 252) {
            return 6;
        }
        return -1;
    }

    public static char bytesToChar(byte[] bytes) {
        return Unicode.bytesToChar(bytes, 0);
    }

    public static char bytesToChar(byte[] bytes, int pos) {
        if (bytes == null) {
            return '\uffff';
        }
        if ((bytes[pos] & 0x80) == 0) {
            return (char)bytes[pos];
        }
        if ((bytes[pos] & 0xE0) == 192) {
            return (char)(((bytes[pos] & 0x1C) << 6) + ((bytes[pos] & 3) << 6) + (bytes[pos + 1] & 0x3F));
        }
        if ((bytes[pos] & 0xF0) == 224) {
            return (char)(((bytes[pos] & 0xF) << 12) + ((bytes[pos + 1] & 0x3C) << 6) + ((bytes[pos + 1] & 3) << 6) + (bytes[pos + 2] & 0x3F));
        }
        if ((bytes[pos] & 0xF8) == 240) {
            return (char)(((bytes[pos] & 7) << 18) + ((bytes[pos + 1] & 0x30) << 16) + ((bytes[pos + 1] & 0xF) << 12) + ((bytes[pos + 2] & 0x3C) << 6) + ((bytes[pos + 2] & 3) << 6) + (bytes[pos + 3] & 0x3F));
        }
        if ((bytes[pos] & 0xFC) == 248) {
            return (char)(((bytes[pos] & 3) << 24) + ((bytes[pos + 1] & 0x3F) << 18) + ((bytes[pos + 2] & 0x30) << 12) + ((bytes[pos + 2] & 0xF) << 12) + ((bytes[pos + 3] & 0x3C) << 6) + ((bytes[pos + 3] & 3) << 6) + (bytes[pos + 4] & 0x3F));
        }
        if ((bytes[pos] & 0xFE) == 252) {
            return (char)(((bytes[pos] & 1) << 30) + ((bytes[pos + 1] & 0x3F) << 24) + ((bytes[pos + 2] & 0x3F) << 18) + ((bytes[pos + 3] & 0x30) << 12) + ((bytes[pos + 3] & 0xF) << 12) + ((bytes[pos + 4] & 0x3C) << 6) + ((bytes[pos + 4] & 3) << 6) + (bytes[pos + 5] & 0x3F));
        }
        return '\uffff';
    }

    public static int countNbBytesPerChar(char car) {
        if ((car & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((car & 0xFFFFF800) == 0) {
            return 2;
        }
        if ((car & 0xFFFF0000) == 0) {
            return 3;
        }
        if ((car & 0xFFE00000) == 0) {
            return 4;
        }
        return -1;
    }

    public static int countBytes(char[] chars) {
        if (chars == null) {
            return 0;
        }
        int nbBytes = 0;
        int currentPos = 0;
        while (currentPos < chars.length) {
            int nbb;
            currentPos += (nbb = Unicode.countNbBytesPerChar(chars[currentPos])) < 4 ? 1 : 2;
            nbBytes += nbb;
        }
        return nbBytes;
    }

    public static int countChars(byte[] bytes) {
        if (bytes == null) {
            return 0;
        }
        int nbChars = 0;
        int currentPos = 0;
        while (currentPos < bytes.length) {
            currentPos += Unicode.countBytesPerChar(bytes, currentPos);
            ++nbChars;
        }
        return nbChars;
    }

    public static byte[] charToBytes(char car) {
        if (car <= '\u007f') {
            byte[] bytes = new byte[]{(byte)car};
            return bytes;
        }
        if (car <= '\u07ff') {
            byte[] bytes = new byte[]{(byte)(192 + ((car & 0x7C0) >> 6)), (byte)(128 + (car & 0x3F))};
            return bytes;
        }
        byte[] bytes = new byte[]{(byte)(224 + ((car & 0xF000) >> 12)), (byte)(128 + ((car & 0xFC0) >> 6)), (byte)(128 + (car & 0x3F))};
        return bytes;
    }

    public static boolean isUnicodeSubset(String str, int pos) {
        if (str == null || str.length() <= pos || pos < 0) {
            return false;
        }
        char c = str.charAt(pos);
        return c > '\u007f' || UNICODE_SUBSET[c];
    }

    public static boolean isUnicodeSubset(char c) {
        return c > '\u007f' || UNICODE_SUBSET[c];
    }

    public static boolean isUnicodeSubset(byte b) {
        return b < 0 || b > 127 || UNICODE_SUBSET[b];
    }

    public static void writeUTF(ObjectOutput objectOutput, String str) throws IOException {
        if (str == null) {
            objectOutput.writeInt(0);
            objectOutput.writeUTF("null");
        } else {
            objectOutput.writeInt(str.length());
            StringBuilder strBuf = new StringBuilder(str);
            while (strBuf != null) {
                if (strBuf.length() < 21845) {
                    objectOutput.writeUTF(strBuf.substring(0, strBuf.length()));
                    strBuf = null;
                    continue;
                }
                objectOutput.writeUTF(strBuf.substring(0, 21845));
                strBuf.delete(0, 21845);
            }
        }
    }

    public static String readUTF(ObjectInput objectInput) throws IOException {
        int strLength = objectInput.readInt();
        StringBuilder strBuf = new StringBuilder(objectInput.readUTF());
        if (strLength == 0 && "null".equals(strBuf.toString())) {
            return null;
        }
        while (strLength > strBuf.length()) {
            strBuf.append(objectInput.readUTF());
        }
        return strBuf.toString();
    }
}

