/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.subtree;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.StringReader;
import java.text.ParseException;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.subtree.ReusableAntlrSubtreeSpecificationChecker;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.subtree.ReusableAntlrSubtreeSpecificationCheckerLexer;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;

public class SubtreeSpecificationChecker {
    private ReusableAntlrSubtreeSpecificationChecker parser;
    private ReusableAntlrSubtreeSpecificationCheckerLexer lexer;

    public SubtreeSpecificationChecker(SchemaManager schemaManager) {
        StringReader in = new StringReader("");
        this.lexer = new ReusableAntlrSubtreeSpecificationCheckerLexer(in);
        this.parser = new ReusableAntlrSubtreeSpecificationChecker(this.lexer);
        this.parser.init(schemaManager);
    }

    private synchronized void reset(String spec) {
        StringReader in = new StringReader(spec + "end");
        this.lexer.prepareNextInput(in);
        this.parser.resetState();
    }

    public synchronized void parse(String spec) throws ParseException {
        if (spec == null || Strings.isEmpty(spec.trim())) {
            return;
        }
        this.reset(spec);
        try {
            this.parser.wrapperEntryPoint();
        }
        catch (RecognitionException | TokenStreamException e) {
            String msg = I18n.err(I18n.ERR_13028_SUBTREE_SPEC_PARSER_FAILURE, spec, e.getLocalizedMessage());
            throw new ParseException(msg, 0);
        }
    }
}

