/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.comparators;

import java.util.UUID;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.comparators.SerializableComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UuidComparator
extends SerializableComparator<String> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(UuidComparator.class);
    public static final UuidComparator INSTANCE = new UuidComparator("1.3.6.1.1.16.4");

    public UuidComparator(String oid) {
        super(oid);
    }

    @Override
    public int compare(String uuid1, String uuid2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_13751_COMPARING_UUID, uuid1, uuid2));
        }
        if (uuid1 == null) {
            return -1;
        }
        return uuid1.compareTo(uuid2);
    }

    @Override
    public int compare(UUID uuid1, UUID uuid2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_13751_COMPARING_UUID, uuid1, uuid2));
        }
        if (uuid1 == null) {
            return uuid2 == null ? 0 : -1;
        }
        if (uuid2 == null) {
            return 1;
        }
        return uuid1.compareTo(uuid2);
    }
}

