/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.comparators;

import org.apache.hadoop.shaded.org.apache.directory.api.asn1.util.Oid;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Chars;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectIdentifierFirstComponentComparator
extends LdapComparator<String> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(ObjectIdentifierFirstComponentComparator.class);

    public ObjectIdentifierFirstComponentComparator(String oid) {
        super(oid);
    }

    private String getNumericOid(String s2) {
        int pos = 0;
        if (!Strings.isCharASCII(s2, pos++, '(')) {
            return null;
        }
        while (Strings.isCharASCII(s2, pos, ' ')) {
            ++pos;
        }
        int start = pos;
        while (Chars.isDigit(s2, pos) || Strings.isCharASCII(s2, pos, '.')) {
            ++pos;
        }
        String numericOid = s2.substring(start, pos);
        if (Oid.isOid(numericOid)) {
            return numericOid;
        }
        return null;
    }

    @Override
    public int compare(String s1, String s2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_13748_COMPARING_OBJECT_IDENTIFIER_FIRST_COMPONENT, s1, s2));
        }
        if (s1 == null) {
            return s2 == null ? 0 : -1;
        }
        if (s2 == null) {
            return -1;
        }
        if (s1.equals(s2)) {
            return 0;
        }
        String oid1 = this.getNumericOid(s1);
        if (oid1 == null) {
            return -1;
        }
        String oid2 = this.getNumericOid(s2);
        if (oid2 == null) {
            return -1;
        }
        if (oid1.equals(oid2)) {
            return 0;
        }
        return -1;
    }
}

