/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.SchemaObjectRenderer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.SchemaObjectType;

public class DitStructureRule
extends AbstractSchemaObject {
    public static final long serialVersionUID = 1L;
    private int ruleId;
    private String form;
    private List<Integer> superRules;

    public DitStructureRule(int ruleId) {
        super(SchemaObjectType.DIT_STRUCTURE_RULE, null);
        this.ruleId = ruleId;
        this.form = null;
        this.superRules = new ArrayList<Integer>();
    }

    public String getForm() {
        return this.form;
    }

    public void setForm(String form) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.form = form;
    }

    public int getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(int ruleId) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.ruleId = ruleId;
    }

    public List<Integer> getSuperRules() {
        return this.superRules;
    }

    public void setSuperRules(List<Integer> superRules) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.superRules = superRules;
    }

    public void addSuperRule(Integer superRule) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.superRules.add(superRule);
    }

    @Override
    public String getOid() {
        return null;
    }

    public String toString() {
        return SchemaObjectRenderer.OPEN_LDAP_SCHEMA_RENDERER.render(this);
    }

    @Override
    public DitStructureRule copy() {
        DitStructureRule copy = new DitStructureRule(this.ruleId);
        copy.copy(this);
        copy.superRules = new ArrayList<Integer>();
        copy.form = this.form;
        for (int superRule : this.superRules) {
            copy.superRules.add(superRule);
        }
        return copy;
    }

    @Override
    public int hashCode() {
        int hash = this.h;
        hash = hash * 17 + this.ruleId;
        if (this.form != null) {
            hash = hash * 17 + this.form.hashCode();
        }
        if (this.superRules != null) {
            int tempHash = 0;
            for (int superRule : this.superRules) {
                tempHash += superRule;
            }
            hash = hash * 17 + tempHash;
        }
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof DitStructureRule)) {
            return false;
        }
        DitStructureRule that = (DitStructureRule)o;
        return true;
    }

    @Override
    public void clear() {
        super.clear();
        this.superRules.clear();
    }
}

