/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.AbstractAbandonableRequest;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.Control;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.ModifyResponse;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.ModifyResponseImpl;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.name.Dn;
import org.apache.hadoop.shaded.org.apache.directory.api.util.StringConstants;

public class ModifyRequestImpl
extends AbstractAbandonableRequest
implements ModifyRequest {
    static final long serialVersionUID = -505803669028990304L;
    private Dn name;
    private List<Modification> mods = new ArrayList<Modification>();
    private ModifyResponse response;

    public ModifyRequestImpl() {
        super(-1, MessageTypeEnum.MODIFY_REQUEST);
    }

    @Override
    public Collection<Modification> getModifications() {
        return Collections.unmodifiableCollection(this.mods);
    }

    @Override
    public Dn getName() {
        return this.name;
    }

    @Override
    public ModifyRequest setName(Dn name) {
        this.name = name;
        return this;
    }

    @Override
    public ModifyRequest addModification(Modification mod) {
        this.mods.add(mod);
        return this;
    }

    private void addModification(ModificationOperation modOp, String attributeName, byte[] ... attributeValue) {
        DefaultAttribute attr = new DefaultAttribute(attributeName, attributeValue);
        this.addModification(attr, modOp);
    }

    private void addModification(ModificationOperation modOp, String attributeName, String ... attributeValue) {
        DefaultAttribute attr = new DefaultAttribute(attributeName, attributeValue);
        this.addModification(attr, modOp);
    }

    @Override
    public ModifyRequest addModification(Attribute attr, ModificationOperation modOp) {
        this.mods.add(new DefaultModification(modOp, attr));
        return this;
    }

    @Override
    public ModifyRequest add(String attributeName, String ... attributeValue) {
        this.addModification(ModificationOperation.ADD_ATTRIBUTE, attributeName, attributeValue);
        return this;
    }

    @Override
    public ModifyRequest add(String attributeName, byte[] ... attributeValue) {
        this.addModification(ModificationOperation.ADD_ATTRIBUTE, attributeName, attributeValue);
        return this;
    }

    @Override
    public ModifyRequest add(Attribute attr) {
        this.addModification(attr, ModificationOperation.ADD_ATTRIBUTE);
        return this;
    }

    @Override
    public ModifyRequest replace(String attributeName) {
        this.addModification(ModificationOperation.REPLACE_ATTRIBUTE, attributeName, StringConstants.EMPTY_STRINGS);
        return this;
    }

    @Override
    public ModifyRequest replace(String attributeName, String ... attributeValue) {
        this.addModification(ModificationOperation.REPLACE_ATTRIBUTE, attributeName, attributeValue);
        return this;
    }

    @Override
    public ModifyRequest replace(String attributeName, byte[] ... attributeValue) {
        this.addModification(ModificationOperation.REPLACE_ATTRIBUTE, attributeName, attributeValue);
        return this;
    }

    @Override
    public ModifyRequest replace(Attribute attr) {
        this.addModification(attr, ModificationOperation.REPLACE_ATTRIBUTE);
        return this;
    }

    @Override
    public ModifyRequest removeModification(Modification mod) {
        this.mods.remove(mod);
        return this;
    }

    @Override
    public ModifyRequest remove(String attributeName, String ... attributeValue) {
        this.addModification(ModificationOperation.REMOVE_ATTRIBUTE, attributeName, attributeValue);
        return this;
    }

    @Override
    public ModifyRequest remove(String attributeName, byte[] ... attributeValue) {
        this.addModification(ModificationOperation.REMOVE_ATTRIBUTE, attributeName, attributeValue);
        return this;
    }

    @Override
    public ModifyRequest remove(Attribute attr) {
        this.addModification(attr, ModificationOperation.REMOVE_ATTRIBUTE);
        return this;
    }

    @Override
    public ModifyRequest remove(String attributeName) {
        this.addModification(new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, attributeName));
        return this;
    }

    @Override
    public ModifyRequest increment(String attributeName) {
        this.addModification(new DefaultModification(ModificationOperation.INCREMENT_ATTRIBUTE, attributeName));
        return this;
    }

    @Override
    public ModifyRequest increment(String attributeName, int increment) {
        this.addModification(new DefaultModification(ModificationOperation.INCREMENT_ATTRIBUTE, attributeName, Integer.toString(increment)));
        return this;
    }

    @Override
    public ModifyRequest increment(Attribute attr) {
        this.addModification(attr, ModificationOperation.INCREMENT_ATTRIBUTE);
        return this;
    }

    @Override
    public ModifyRequest increment(Attribute attr, int increment) {
        this.addModification(new DefaultModification(ModificationOperation.INCREMENT_ATTRIBUTE, attr.getId(), Integer.toString(increment)));
        return this;
    }

    @Override
    public ModifyRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    @Override
    public ModifyRequest addControl(Control control) {
        return (ModifyRequest)super.addControl(control);
    }

    @Override
    public ModifyRequest addAllControls(Control[] controls) {
        return (ModifyRequest)super.addAllControls(controls);
    }

    @Override
    public ModifyRequest removeControl(Control control) {
        return (ModifyRequest)super.removeControl(control);
    }

    @Override
    public MessageTypeEnum getResponseType() {
        return MessageTypeEnum.MODIFY_RESPONSE;
    }

    @Override
    public ModifyResponse getResultResponse() {
        if (this.response == null) {
            this.response = new ModifyResponseImpl(this.getMessageId());
        }
        return this.response;
    }

    @Override
    public int hashCode() {
        int hash = 37;
        if (this.name != null) {
            hash = hash * 17 + this.name.hashCode();
        }
        hash = hash * 17 + this.mods.size();
        for (int i = 0; i < this.mods.size(); ++i) {
            hash = hash * 17 + ((DefaultModification)this.mods.get(i)).hashCode();
        }
        hash = hash * 17 + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ModifyRequest req = (ModifyRequest)obj;
        if (this.name != null && req.getName() == null) {
            return false;
        }
        if (this.name == null && req.getName() != null) {
            return false;
        }
        if (this.name != null && req.getName() != null && !this.name.equals(req.getName())) {
            return false;
        }
        if (req.getModifications().size() != this.mods.size()) {
            return false;
        }
        Iterator<Modification> list = req.getModifications().iterator();
        for (int i = 0; i < this.mods.size(); ++i) {
            Modification item = list.next();
            if (!(item == null ? this.mods.get(i) != null : !item.equals(this.mods.get(i)))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Modify Request\n");
        sb.append("        Object : '").append(this.name).append("'\n");
        if (this.mods != null) {
            sb.append("        Modifications : \n");
            for (int i = 0; i < this.mods.size(); ++i) {
                DefaultModification modification = (DefaultModification)this.mods.get(i);
                sb.append("            Modification[").append(i).append("]\n");
                sb.append("                Operation : ");
                switch (modification.getOperation()) {
                    case ADD_ATTRIBUTE: {
                        sb.append(" add\n");
                        break;
                    }
                    case REPLACE_ATTRIBUTE: {
                        sb.append(" replace\n");
                        break;
                    }
                    case REMOVE_ATTRIBUTE: {
                        sb.append(" delete\n");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(I18n.err(I18n.ERR_13515_UNEXPECTED_MOD_OP, new Object[]{modification.getOperation()}));
                    }
                }
                sb.append("                Modification : ");
                sb.append(modification.getAttribute());
                sb.append("\n");
            }
        }
        return super.toString(sb.toString());
    }
}

