/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.constants;

public enum LdapSecurityConstants {
    HASH_METHOD_SHA("SHA", "SHA", "sha"),
    HASH_METHOD_SSHA("SSHA", "SHA", "ssha"),
    HASH_METHOD_SHA256("SHA-256", "SHA-256", "sha256"),
    HASH_METHOD_SSHA256("SSHA-256", "SHA-256", "ssha256"),
    HASH_METHOD_SHA384("SHA-384", "SHA-384", "sha384"),
    HASH_METHOD_SSHA384("SSHA-384", "SHA-384", "ssha384"),
    HASH_METHOD_SHA512("SHA-512", "SHA-512", "sha512"),
    HASH_METHOD_SSHA512("SSHA-512", "SHA-512", "ssha512"),
    HASH_METHOD_MD5("MD5", "MD5", "md5"),
    HASH_METHOD_SMD5("SMD5", "MD5", "smd5"),
    HASH_METHOD_CRYPT("CRYPT", "CRYPT", "crypt"),
    HASH_METHOD_CRYPT_MD5("CRYPT-MD5", "MD5", "crypt", "$1$"),
    HASH_METHOD_CRYPT_SHA256("CRYPT-SHA-256", "SHA-256", "crypt", "$5$"),
    HASH_METHOD_CRYPT_SHA512("CRYPT-SHA-512", "SHA-512", "crypt", "$6$"),
    HASH_METHOD_CRYPT_BCRYPT("CRYPT-BCRYPT", "BCRYPT", "crypt", "$2a$"),
    HASH_METHOD_PKCS5S2("PKCS5S2", "PBKDF2WithHmacSHA1", "PKCS5S2");

    private String name;
    private String algorithm;
    private String prefix;
    private String subPrefix;

    private LdapSecurityConstants(String name, String algorithm, String prefix) {
        this(name, algorithm, prefix, "");
    }

    private LdapSecurityConstants(String name, String algorithm, String prefix, String subPrefix) {
        this.name = name;
        this.algorithm = algorithm;
        this.prefix = prefix;
        this.subPrefix = subPrefix;
    }

    public String getName() {
        return this.name;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSubPrefix() {
        return this.subPrefix;
    }

    public static LdapSecurityConstants getAlgorithm(String algorithm) {
        if (LdapSecurityConstants.matches(algorithm, HASH_METHOD_SHA)) {
            return HASH_METHOD_SHA;
        }
        if (LdapSecurityConstants.matches(algorithm, HASH_METHOD_SSHA)) {
            return HASH_METHOD_SSHA;
        }
        if (LdapSecurityConstants.matches(algorithm, HASH_METHOD_MD5)) {
            return HASH_METHOD_MD5;
        }
        if (LdapSecurityConstants.matches(algorithm, HASH_METHOD_SMD5)) {
            return HASH_METHOD_SMD5;
        }
        if (LdapSecurityConstants.matches(algorithm, HASH_METHOD_CRYPT)) {
            return HASH_METHOD_CRYPT;
        }
        if (LdapSecurityConstants.matches(algorithm, HASH_METHOD_CRYPT_MD5)) {
            return HASH_METHOD_CRYPT_MD5;
        }
        if (LdapSecurityConstants.matches(algorithm, HASH_METHOD_CRYPT_SHA256)) {
            return HASH_METHOD_CRYPT_SHA256;
        }
        if (LdapSecurityConstants.matches(algorithm, HASH_METHOD_CRYPT_SHA512)) {
            return HASH_METHOD_CRYPT_SHA512;
        }
        if (LdapSecurityConstants.matches(algorithm, HASH_METHOD_CRYPT_BCRYPT)) {
            return HASH_METHOD_CRYPT_BCRYPT;
        }
        if (LdapSecurityConstants.matches(algorithm, HASH_METHOD_SHA256)) {
            return HASH_METHOD_SHA256;
        }
        if (LdapSecurityConstants.matches(algorithm, HASH_METHOD_SSHA256)) {
            return HASH_METHOD_SSHA256;
        }
        if (LdapSecurityConstants.matches(algorithm, HASH_METHOD_SHA384)) {
            return HASH_METHOD_SHA384;
        }
        if (LdapSecurityConstants.matches(algorithm, HASH_METHOD_SSHA384)) {
            return HASH_METHOD_SSHA384;
        }
        if (LdapSecurityConstants.matches(algorithm, HASH_METHOD_SHA512)) {
            return HASH_METHOD_SHA512;
        }
        if (LdapSecurityConstants.matches(algorithm, HASH_METHOD_SSHA512)) {
            return HASH_METHOD_SSHA512;
        }
        if (LdapSecurityConstants.matches(algorithm, HASH_METHOD_PKCS5S2)) {
            return HASH_METHOD_PKCS5S2;
        }
        return null;
    }

    private static boolean matches(String algorithm, LdapSecurityConstants constant) {
        return constant.name.equalsIgnoreCase(algorithm) || (constant.prefix + constant.subPrefix).equalsIgnoreCase(algorithm);
    }
}

