/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.search;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.EncoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.search.ConnectorFilter;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.search.Filter;

public class AndFilter
extends ConnectorFilter {
    public AndFilter(int tlvId) {
        super(tlvId);
    }

    public AndFilter() {
    }

    public List<Filter> getAndFilter() {
        return this.filterSet;
    }

    @Override
    public int computeLength() {
        this.filtersLength = super.computeLength();
        return 1 + TLV.getNbBytes(this.filtersLength) + this.filtersLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_08000_CANNOT_PUT_A_PDU_IN_NULL_BUFFER, new Object[0]));
        }
        try {
            buffer.put((byte)-96);
            buffer.put(TLV.getBytes(this.filtersLength));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_08212_PDU_BUFFER_TOO_SMALL, new Object[0]), boe);
        }
        super.encode(buffer);
        return buffer;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('&').append(super.toString());
        return sb.toString();
    }
}

