/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.actions.request.bind;

import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreSaslMechanism
extends GrammarAction<LdapMessageContainer<BindRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSaslMechanism.class);

    public StoreSaslMechanism() {
        super("Store SASL mechanism");
    }

    @Override
    public void action(LdapMessageContainer<BindRequest> container) {
        BindRequest bindRequestMessage = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            bindRequestMessage.setSaslMechanism("");
        } else {
            bindRequestMessage.setSaslMechanism(Strings.utf8ToString(tlv.getValue().getData()));
        }
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_05118_THE_SASL_MECHANISM_IS, bindRequestMessage.getSaslMechanism()));
        }
    }
}

