/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.protocol;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.RequestMessage;

public final class OpenStreamWithCredit
extends RequestMessage {
    public final byte[] shuffleKey;
    public final byte[] fileName;
    public final int startIndex;
    public final int endIndex;
    public final int initialCredit;

    public OpenStreamWithCredit(byte[] shuffleKey, byte[] fileName, int startIndex, int endIndex, int initialCredit) {
        this.shuffleKey = shuffleKey;
        this.fileName = fileName;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.initialCredit = initialCredit;
    }

    public OpenStreamWithCredit(String shuffleKey, String fileName, int startIndex, int endIndex, int initialCredit) {
        this(shuffleKey.getBytes(StandardCharsets.UTF_8), fileName.getBytes(StandardCharsets.UTF_8), startIndex, endIndex, initialCredit);
    }

    @Override
    public int encodedLength() {
        return 4 + this.shuffleKey.length + 4 + this.fileName.length + 4 + 4 + 4;
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeInt(this.shuffleKey.length);
        buf.writeBytes(this.shuffleKey);
        buf.writeInt(this.fileName.length);
        buf.writeBytes(this.fileName);
        buf.writeInt(this.startIndex);
        buf.writeInt(this.endIndex);
        buf.writeInt(this.initialCredit);
    }

    @Override
    public Message.Type type() {
        return Message.Type.OPEN_STREAM_WITH_CREDIT;
    }

    public static OpenStreamWithCredit decode(ByteBuf in) {
        int shuffleKeyLength = in.readInt();
        byte[] tmpShuffleKey = new byte[shuffleKeyLength];
        in.readBytes(tmpShuffleKey);
        int fileNameLength = in.readInt();
        byte[] tmpFileName = new byte[fileNameLength];
        in.readBytes(tmpFileName);
        int startSubIndex = in.readInt();
        int endSubIndex = in.readInt();
        int initialCredit = in.readInt();
        return new OpenStreamWithCredit(tmpShuffleKey, tmpFileName, startSubIndex, endSubIndex, initialCredit);
    }
}

