/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import java.io.IOException;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.meta.FileInfo;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.protocol.PartitionSplitMode;
import org.apache.celeborn.common.protocol.PartitionType;
import org.apache.celeborn.service.deploy.worker.storage.DeviceMonitor;
import org.apache.celeborn.service.deploy.worker.storage.FileWriter;
import org.apache.celeborn.service.deploy.worker.storage.Flusher;
import org.apache.celeborn.service.deploy.worker.storage.StorageManager;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReducePartitionFileWriter
extends FileWriter {
    private static final Logger logger = LoggerFactory.getLogger(ReducePartitionFileWriter.class);
    private long nextBoundary;
    private final long shuffleChunkSize;

    public ReducePartitionFileWriter(FileInfo fileInfo, Flusher flusher, AbstractSource workerSource, CelebornConf conf, DeviceMonitor deviceMonitor, long splitThreshold, PartitionSplitMode splitMode, boolean rangeReadFilter) throws IOException {
        super(fileInfo, flusher, workerSource, conf, deviceMonitor, splitThreshold, splitMode, PartitionType.REDUCE, rangeReadFilter);
        this.nextBoundary = this.shuffleChunkSize = conf.shuffleChunkSize();
    }

    @Override
    protected void flush(boolean finalFlush) throws IOException {
        super.flush(finalFlush);
        this.maybeSetChunkOffsets(finalFlush);
    }

    private void maybeSetChunkOffsets(boolean forceSet) {
        long bytesFlushed = this.fileInfo.getFileLength();
        if (bytesFlushed >= this.nextBoundary || forceSet) {
            this.fileInfo.addChunkOffset(bytesFlushed);
            this.nextBoundary = bytesFlushed + this.shuffleChunkSize;
        }
    }

    private boolean isChunkOffsetValid() {
        return this.fileInfo.getLastChunkOffset() == this.fileInfo.getFileLength();
    }

    @Override
    public synchronized long close() throws IOException {
        return super.close(() -> {
            if (!this.isChunkOffsetValid()) {
                this.maybeSetChunkOffsets(true);
            }
        }, () -> {
            if (StorageManager.hadoopFs().exists(this.fileInfo.getHdfsPeerWriterSuccessPath())) {
                StorageManager.hadoopFs().delete(this.fileInfo.getHdfsPath(), false);
                this.deleted = true;
            } else {
                StorageManager.hadoopFs().create(this.fileInfo.getHdfsWriterSuccessPath()).close();
                FSDataOutputStream indexOutputStream = StorageManager.hadoopFs().create(this.fileInfo.getHdfsIndexPath());
                indexOutputStream.writeInt(this.fileInfo.getChunkOffsets().size());
                for (Long offset : this.fileInfo.getChunkOffsets()) {
                    indexOutputStream.writeLong(offset.longValue());
                }
                indexOutputStream.close();
            }
        }, () -> {});
    }
}

