/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.meta.FileInfo;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.protocol.PartitionSplitMode;
import org.apache.celeborn.common.protocol.PartitionType;
import org.apache.celeborn.common.util.Utils;
import org.apache.celeborn.service.deploy.worker.storage.DeviceMonitor;
import org.apache.celeborn.service.deploy.worker.storage.FileChannelUtils;
import org.apache.celeborn.service.deploy.worker.storage.FileWriter;
import org.apache.celeborn.service.deploy.worker.storage.Flusher;
import org.apache.celeborn.service.deploy.worker.storage.StorageManager;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapPartitionFileWriter
extends FileWriter {
    private static final Logger logger = LoggerFactory.getLogger(MapPartitionFileWriter.class);
    private int numSubpartitions;
    private int currentDataRegionIndex;
    private boolean isBroadcastRegion;
    private long[] numSubpartitionBytes;
    private ByteBuffer indexBuffer;
    private int currentSubpartition;
    private long totalBytes;
    private long regionStartingOffset;
    private FileChannel indexChannel;

    public MapPartitionFileWriter(FileInfo fileInfo, Flusher flusher, AbstractSource workerSource, CelebornConf conf, DeviceMonitor deviceMonitor, long splitThreshold, PartitionSplitMode splitMode, boolean rangeReadFilter) throws IOException {
        super(fileInfo, flusher, workerSource, conf, deviceMonitor, splitThreshold, splitMode, PartitionType.MAP, rangeReadFilter);
        if (!fileInfo.isHdfs()) {
            this.indexChannel = FileChannelUtils.createWritableFileChannel(fileInfo.getIndexPath());
        } else {
            try {
                StorageManager.hadoopFs().create(fileInfo.getHdfsIndexPath(), true).close();
            }
            catch (IOException e) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                StorageManager.hadoopFs().create(fileInfo.getHdfsIndexPath(), true).close();
            }
        }
    }

    @Override
    public void write(ByteBuf data) throws IOException {
        data.markReaderIndex();
        int partitionId = data.readInt();
        int attemptId = data.readInt();
        int batchId = data.readInt();
        int size = data.readInt();
        data.resetReaderIndex();
        logger.debug("mappartition filename:{} write partition:{} attemptId:{} batchId:{} size:{}", new Object[]{this.fileInfo.getFilePath(), partitionId, attemptId, batchId, size});
        if (partitionId < this.currentSubpartition) {
            throw new IOException("Must writing data in reduce partition index order, but now partitionId is " + partitionId + " and pre partitionId is " + this.currentSubpartition);
        }
        if (partitionId > this.currentSubpartition) {
            this.currentSubpartition = partitionId;
        }
        long length = data.readableBytes();
        this.totalBytes += length;
        int n = partitionId;
        this.numSubpartitionBytes[n] = this.numSubpartitionBytes[n] + length;
        super.write(data);
    }

    @Override
    public synchronized long close() throws IOException {
        return super.close(() -> this.flushIndex(), () -> {
            if (StorageManager.hadoopFs().exists(this.fileInfo.getHdfsPeerWriterSuccessPath())) {
                StorageManager.hadoopFs().delete(this.fileInfo.getHdfsPath(), false);
                this.deleted = true;
            } else {
                StorageManager.hadoopFs().create(this.fileInfo.getHdfsWriterSuccessPath()).close();
            }
        }, () -> {
            if (this.indexChannel != null) {
                this.indexChannel.close();
            }
            if (this.fileInfo.isHdfs()) {
                if (StorageManager.hadoopFs().exists(new Path(Utils.getWriteSuccessFilePath((String)Utils.getPeerPath((String)this.fileInfo.getIndexPath()))))) {
                    StorageManager.hadoopFs().delete(this.fileInfo.getHdfsIndexPath(), false);
                    this.deleted = true;
                } else {
                    StorageManager.hadoopFs().create(new Path(Utils.getWriteSuccessFilePath((String)this.fileInfo.getIndexPath()))).close();
                }
            }
        });
    }

    @Override
    public synchronized void destroy(IOException ioException) {
        this.destroyIndex();
        super.destroy(ioException);
    }

    public void pushDataHandShake(int numSubpartitions, int bufferSize) {
        logger.debug("FileWriter:{} pushDataHandShake numReducePartitions:{} bufferSize:{}", new Object[]{this.fileInfo.getFilePath(), numSubpartitions, bufferSize});
        this.numSubpartitions = numSubpartitions;
        this.numSubpartitionBytes = new long[numSubpartitions];
        this.fileInfo.setBufferSize(bufferSize);
        this.fileInfo.setNumSubpartitions(numSubpartitions);
    }

    public void regionStart(int currentDataRegionIndex, boolean isBroadcastRegion) {
        logger.debug("FileWriter:{} regionStart currentDataRegionIndex:{} isBroadcastRegion:{}", new Object[]{this.fileInfo.getFilePath(), currentDataRegionIndex, isBroadcastRegion});
        this.currentSubpartition = 0;
        this.currentDataRegionIndex = currentDataRegionIndex;
        this.isBroadcastRegion = isBroadcastRegion;
    }

    public void regionFinish() throws IOException {
        logger.debug("FileWriter:{} regionFinish", (Object)this.fileInfo.getFilePath());
        if (this.regionStartingOffset == this.totalBytes) {
            return;
        }
        long fileOffset = this.regionStartingOffset;
        if (this.indexBuffer == null) {
            this.indexBuffer = this.allocateIndexBuffer(this.numSubpartitions);
        }
        for (int partitionIndex = 0; partitionIndex < this.numSubpartitions; ++partitionIndex) {
            this.indexBuffer.putLong(fileOffset);
            if (!this.isBroadcastRegion) {
                logger.debug("flush index filename:{} region:{} partitionid:{} flush index fileOffset:{}, size:{} ", new Object[]{this.fileInfo.getFilePath(), this.currentDataRegionIndex, partitionIndex, fileOffset, this.numSubpartitionBytes[partitionIndex]});
                this.indexBuffer.putLong(this.numSubpartitionBytes[partitionIndex]);
                fileOffset += this.numSubpartitionBytes[partitionIndex];
                continue;
            }
            logger.debug("flush index broadcast filename:{} region:{} partitionid:{}  fileOffset:{}, size:{} ", new Object[]{this.fileInfo.getFilePath(), this.currentDataRegionIndex, partitionIndex, fileOffset, this.numSubpartitionBytes[0]});
            this.indexBuffer.putLong(this.numSubpartitionBytes[0]);
        }
        if (!this.indexBuffer.hasRemaining()) {
            this.flushIndex();
        }
        this.regionStartingOffset = this.totalBytes;
        Arrays.fill(this.numSubpartitionBytes, 0L);
    }

    private synchronized void destroyIndex() {
        try {
            if (this.indexChannel != null) {
                this.indexChannel.close();
            }
        }
        catch (IOException e) {
            logger.warn("Close channel failed for file {} caused by {}.", (Object)this.fileInfo.getIndexPath(), (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushIndex() throws IOException {
        if (this.indexBuffer != null) {
            logger.debug("flushIndex start:{}", (Object)this.fileInfo.getIndexPath());
            long startTime = System.currentTimeMillis();
            this.indexBuffer.flip();
            this.notifier.checkException();
            try {
                if (this.indexBuffer.hasRemaining()) {
                    if (this.indexChannel != null) {
                        while (this.indexBuffer.hasRemaining()) {
                            this.indexChannel.write(this.indexBuffer);
                        }
                    } else if (this.fileInfo.isHdfs()) {
                        FSDataOutputStream hdfsStream = StorageManager.hadoopFs().append(this.fileInfo.getHdfsIndexPath());
                        hdfsStream.write(this.indexBuffer.array());
                        hdfsStream.close();
                    }
                }
                this.indexBuffer.clear();
            }
            finally {
                logger.debug("flushIndex end:{}, cost:{}", (Object)this.fileInfo.getIndexPath(), (Object)(System.currentTimeMillis() - startTime));
            }
        }
    }

    private ByteBuffer allocateIndexBuffer(int numSubpartitions) {
        int indexRegionSize = numSubpartitions * 16;
        int minBufferSize = 4096;
        if (indexRegionSize >= minBufferSize) {
            ByteBuffer buffer = ByteBuffer.allocateDirect(indexRegionSize);
            buffer.order(ByteOrder.BIG_ENDIAN);
            return buffer;
        }
        int numRegions = minBufferSize / indexRegionSize;
        if (minBufferSize % indexRegionSize != 0) {
            ++numRegions;
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(numRegions * indexRegionSize);
        buffer.order(ByteOrder.BIG_ENDIAN);
        return buffer;
    }
}

