/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.DeviceInfo;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.apache.celeborn.common.util.Utils$;
import org.apache.celeborn.service.deploy.worker.storage.DeviceMonitor;
import org.apache.celeborn.service.deploy.worker.storage.DeviceObserver;
import org.apache.celeborn.service.deploy.worker.storage.EmptyDeviceMonitor$;
import org.apache.celeborn.service.deploy.worker.storage.LocalDeviceMonitor;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class DeviceMonitor$
implements Logging {
    public static DeviceMonitor$ MODULE$;
    private final ThreadPoolExecutor deviceCheckThreadPool;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    static {
        new DeviceMonitor$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        DeviceMonitor$ deviceMonitor$ = this;
        synchronized (deviceMonitor$) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public ThreadPoolExecutor deviceCheckThreadPool() {
        return this.deviceCheckThreadPool;
    }

    public DeviceMonitor createDeviceMonitor(CelebornConf conf, DeviceObserver deviceObserver, Map<String, DeviceInfo> deviceInfos, Map<String, DiskInfo> diskInfos, AbstractSource workerSource) {
        DeviceMonitor deviceMonitor;
        try {
            if (conf.workerDiskMonitorEnabled()) {
                LocalDeviceMonitor monitor = new LocalDeviceMonitor(conf, deviceObserver, deviceInfos, diskInfos, workerSource);
                monitor.init();
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Device monitor init success");
                deviceMonitor = monitor;
            } else {
                deviceMonitor = EmptyDeviceMonitor$.MODULE$;
            }
        }
        catch (Throwable t) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Device monitor init failed.", t);
            throw t;
        }
        return deviceMonitor;
    }

    public String[] getDiskUsageInfos(DiskInfo diskInfo) {
        return Utils$.MODULE$.runCommand(new StringBuilder(7).append("df -B1 ").append(diskInfo.mountPoint()).toString()).trim().split("[ \t]+");
    }

    public boolean highDiskUsage(CelebornConf conf, DiskInfo diskInfo) {
        return BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryWithTimeoutAndCallback((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean highDiskUsage;
            block0: {
                String[] usage = MODULE$.getDiskUsageInfos(diskInfo);
                String totalSpace = usage[usage.length - 5];
                String freeSpace = usage[usage.length - 3];
                String used_percent = usage[usage.length - 2];
                boolean bl = highDiskUsage = new StringOps(Predef$.MODULE$.augmentString(freeSpace)).toLong() < conf.workerDiskReserveSize() || diskInfo.actualUsableSpace() <= 0L;
                if (!highDiskUsage) break block0;
                MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(124).append(diskInfo.mountPoint()).append(" usage is above threshold.").append(" Disk usage(Report by OS):{total:").append(Utils$.MODULE$.bytesToString(new StringOps(Predef$.MODULE$.augmentString(totalSpace)).toLong())).append(",").append(" free:").append(Utils$.MODULE$.bytesToString(new StringOps(Predef$.MODULE$.augmentString(freeSpace)).toLong())).append(", used_percent:").append(used_percent).append("} ").append("usage(Report by Celeborn):{").append("total:").append(Utils$.MODULE$.bytesToString(diskInfo.configuredUsableSpace())).append(" free:").append(Utils$.MODULE$.bytesToString(diskInfo.actualUsableSpace())).append(" }").toString());
            }
            return highDiskUsage;
        }, (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, this.deviceCheckThreadPool(), conf.workerDiskMonitorStatusCheckTimeout(), new StringBuilder(26).append("Disk: ").append(diskInfo.mountPoint()).append(" Usage Check Timeout").toString()));
    }

    public boolean readWriteError(CelebornConf conf, File dataDir) {
        if (dataDir == null) {
            return false;
        }
        return BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryWithTimeoutAndCallback((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            block6: {
                try {
                    Object object = !dataDir.exists() ? BoxesRunTime.boxToBoolean((boolean)dataDir.mkdirs()) : BoxedUnit.UNIT;
                    File file = new File(dataDir, new StringBuilder(9).append("_SUCCESS_").append(System.currentTimeMillis()).toString());
                    if (!file.exists() && !file.createNewFile()) {
                        bl = true;
                        break block6;
                    }
                    FileUtils.write((File)file, (CharSequence)"test", (Charset)Charset.defaultCharset());
                    FileInputStream fileInputStream = null;
                    InputStreamReader inputStreamReader = null;
                    BufferedReader bufferReader = null;
                    try {
                        fileInputStream = FileUtils.openInputStream((File)file);
                        inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charset.defaultCharset());
                        bufferReader = new BufferedReader(inputStreamReader);
                        bufferReader.readLine();
                    }
                    finally {
                        bufferReader.close();
                        inputStreamReader.close();
                        fileInputStream.close();
                    }
                    FileUtils.forceDelete((File)file);
                    bl = false;
                }
                catch (Throwable t) {
                    MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Disk dir ").append(dataDir).append(" cannot read or write").toString(), t);
                    bl = true;
                }
            }
            return bl;
        }, (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, this.deviceCheckThreadPool(), conf.workerDiskMonitorStatusCheckTimeout(), new StringBuilder(31).append("Disk: ").append(dataDir).append(" Read_Write Check Timeout").toString()));
    }

    public DeviceMonitor EmptyMonitor() {
        return EmptyDeviceMonitor$.MODULE$;
    }

    private DeviceMonitor$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.deviceCheckThreadPool = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("device-check-thread", 5, ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3());
    }
}

