/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.celeborn.common.meta.FileManagedBuffers;
import org.apache.celeborn.common.meta.TimeWindow;
import org.apache.celeborn.common.network.buffer.ManagedBuffer;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkStreamManager {
    private static final Logger logger = LoggerFactory.getLogger(ChunkStreamManager.class);
    private final AtomicLong nextStreamId = new AtomicLong((long)new Random().nextInt(Integer.MAX_VALUE) * 1000L);
    protected final ConcurrentHashMap<Long, StreamState> streams = JavaUtils.newConcurrentHashMap();
    protected final ConcurrentHashMap<String, Set<Long>> shuffleStreamIds = JavaUtils.newConcurrentHashMap();

    public ManagedBuffer getChunk(long streamId, int chunkIndex, int offset, int len) {
        StreamState state = this.streams.get(streamId);
        if (state == null) {
            throw new IllegalStateException(String.format("Stream %s for chunk %s is not registered(Maybe removed).", streamId, chunkIndex));
        }
        if (chunkIndex >= state.buffers.numChunks()) {
            throw new IllegalStateException(String.format("Requested chunk index beyond end %s", chunkIndex));
        }
        FileManagedBuffers buffers = state.buffers;
        ManagedBuffer nextChunk = buffers.chunk(chunkIndex, offset, len);
        return nextChunk;
    }

    public TimeWindow getFetchTimeMetric(long streamId) {
        StreamState state = this.streams.get(streamId);
        if (state != null) {
            return state.fetchTimeMetric;
        }
        return null;
    }

    public static String genStreamChunkId(long streamId, int chunkId) {
        return String.format("%d_%d", streamId, chunkId);
    }

    public static Pair<Long, Integer> parseStreamChunkId(String streamChunkId) {
        String[] array = streamChunkId.split("_");
        assert (array.length == 2) : "Stream id and chunk index should be specified.";
        long streamId = Long.parseLong(array[0]);
        int chunkIndex = Integer.parseInt(array[1]);
        return ImmutablePair.of((Object)streamId, (Object)chunkIndex);
    }

    public void chunkBeingSent(long streamId) {
        StreamState streamState = this.streams.get(streamId);
        if (streamState != null) {
            ++streamState.chunksBeingTransferred;
        }
    }

    public void chunkSent(long streamId) {
        StreamState streamState = this.streams.get(streamId);
        if (streamState != null) {
            --streamState.chunksBeingTransferred;
        }
    }

    public long chunksBeingTransferred() {
        long sum = 0L;
        for (StreamState streamState : this.streams.values()) {
            sum += streamState.chunksBeingTransferred;
        }
        return sum;
    }

    public long registerStream(String shuffleKey, FileManagedBuffers buffers, TimeWindow fetchTimeMetric) {
        long myStreamId = this.nextStreamId.getAndIncrement();
        this.streams.put(myStreamId, new StreamState(shuffleKey, buffers, fetchTimeMetric));
        this.shuffleStreamIds.compute(shuffleKey, (key, value) -> {
            if (value == null) {
                value = ConcurrentHashMap.newKeySet();
            }
            value.add(myStreamId);
            return value;
        });
        return myStreamId;
    }

    public void cleanupExpiredShuffleKey(Set<String> expiredShuffleKeys) {
        for (String expiredShuffleKey : expiredShuffleKeys) {
            Set<Long> expiredStreamIds = this.shuffleStreamIds.remove(expiredShuffleKey);
            if (expiredStreamIds == null || expiredStreamIds.isEmpty()) continue;
            ((ConcurrentHashMap.KeySetView)this.streams.keySet()).removeAll(expiredStreamIds);
        }
    }

    @VisibleForTesting
    public int numStreamStates() {
        return this.streams.size();
    }

    @VisibleForTesting
    public long numShuffleSteams() {
        return this.shuffleStreamIds.values().stream().flatMap(Collection::stream).count();
    }

    protected static class StreamState {
        final FileManagedBuffers buffers;
        final String shuffleKey;
        final TimeWindow fetchTimeMetric;
        volatile long chunksBeingTransferred = 0L;

        StreamState(String shuffleKey, FileManagedBuffers buffers, TimeWindow fetchTimeMetric) {
            this.buffers = (FileManagedBuffers)Preconditions.checkNotNull((Object)buffers);
            this.shuffleKey = shuffleKey;
            this.fetchTimeMetric = fetchTimeMetric;
        }
    }
}

