/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.memory;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.util.internal.PlatformDependent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.util.ThreadUtils;
import org.apache.celeborn.common.util.Utils;
import org.apache.celeborn.reflect.DynMethods;
import org.apache.celeborn.service.deploy.worker.memory.ReadBufferDispatcher;
import org.apache.celeborn.service.deploy.worker.memory.ReadBufferRequest;
import org.apache.celeborn.service.deploy.worker.storage.CreditStreamManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryManager {
    private static final Logger logger = LoggerFactory.getLogger(MemoryManager.class);
    private static volatile MemoryManager _INSTANCE = null;
    private long maxDirectorMemory = 0L;
    private final long pausePushDataThreshold;
    private final long pauseReplicateThreshold;
    private final long resumeThreshold;
    private final long maxSortMemory;
    private final List<MemoryPressureListener> memoryPressureListeners = new ArrayList<MemoryPressureListener>();
    private final ScheduledExecutorService checkService = ThreadUtils.newDaemonSingleThreadScheduledExecutor((String)"memory-manager-checker");
    private final ScheduledExecutorService reportService = ThreadUtils.newDaemonSingleThreadScheduledExecutor((String)"memory-manager-reporter");
    private final ExecutorService actionService = ThreadUtils.newDaemonSingleThreadExecutor((String)"memory-manager-actor");
    private final AtomicBoolean trimInProcess = new AtomicBoolean(false);
    private final AtomicLong sortMemoryCounter = new AtomicLong(0L);
    private final AtomicLong diskBufferCounter = new AtomicLong(0L);
    private final LongAdder pausePushDataCounter = new LongAdder();
    private final LongAdder pausePushDataAndReplicateCounter = new LongAdder();
    private ServingState servingState = ServingState.NONE_PAUSED;
    private boolean underPressure;
    private final AtomicLong readBufferCounter = new AtomicLong(0L);
    private long readBufferThreshold = 0L;
    private long readBufferTarget = 0L;
    private ReadBufferDispatcher readBufferDispatcher;
    private List<ReadBufferTargetChangeListener> readBufferTargetChangeListeners;
    private long lastNotifiedTarget = 0L;
    private final ScheduledExecutorService readBufferTargetUpdateService = ThreadUtils.newDaemonSingleThreadScheduledExecutor((String)"memory-manager-read-buffer-target-updater");
    private CreditStreamManager creditStreamManager = null;
    private long memoryShuffleStorageThreshold = 0L;

    public static MemoryManager initialize(CelebornConf conf) {
        if (_INSTANCE == null) {
            _INSTANCE = new MemoryManager(conf);
        }
        return _INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMemoryListener(MemoryPressureListener listener) {
        List<MemoryPressureListener> list = this.memoryPressureListeners;
        synchronized (list) {
            this.memoryPressureListeners.add(listener);
        }
    }

    public static MemoryManager instance() {
        return _INSTANCE;
    }

    private MemoryManager(CelebornConf conf) {
        double pausePushDataRatio = conf.workerDirectMemoryRatioToPauseReceive();
        double pauseReplicateRatio = conf.workerDirectMemoryRatioToPauseReplicate();
        double resumeRatio = conf.workerDirectMemoryRatioToResume();
        double maxSortMemRatio = conf.partitionSorterDirectMemoryRatioThreshold();
        double readBufferRatio = conf.workerDirectMemoryRatioForReadBuffer();
        double shuffleStorageRatio = conf.workerDirectMemoryRatioForShuffleStorage();
        long checkInterval = conf.workerDirectMemoryPressureCheckIntervalMs();
        long reportInterval = conf.workerDirectMemoryReportIntervalSecond();
        double readBufferTargetRatio = conf.readBufferTargetRatio();
        long readBufferTargetUpdateInterval = conf.readBufferTargetUpdateInterval();
        long readBufferTargetNotifyThreshold = conf.readBufferTargetNotifyThreshold();
        this.maxDirectorMemory = (Long)DynMethods.builder((String)"maxDirectMemory").impl("jdk.internal.misc.VM", new Class[0]).impl("sun.misc.VM", new Class[0]).buildStatic().invoke(new Object[0]);
        Preconditions.checkArgument((this.maxDirectorMemory > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((pauseReplicateRatio > pausePushDataRatio ? 1 : 0) != 0);
        Preconditions.checkArgument((pausePushDataRatio > resumeRatio ? 1 : 0) != 0);
        Preconditions.checkArgument((resumeRatio > readBufferRatio + shuffleStorageRatio ? 1 : 0) != 0);
        this.maxSortMemory = (long)((double)this.maxDirectorMemory * maxSortMemRatio);
        this.pausePushDataThreshold = (long)((double)this.maxDirectorMemory * pausePushDataRatio);
        this.pauseReplicateThreshold = (long)((double)this.maxDirectorMemory * pauseReplicateRatio);
        this.resumeThreshold = (long)((double)this.maxDirectorMemory * resumeRatio);
        this.readBufferThreshold = (long)((double)this.maxDirectorMemory * readBufferRatio);
        this.readBufferTarget = (long)((double)this.readBufferThreshold * readBufferTargetRatio);
        this.memoryShuffleStorageThreshold = (long)((double)this.maxDirectorMemory * shuffleStorageRatio);
        this.checkService.scheduleWithFixedDelay(() -> {
            try {
                ServingState lastState = this.servingState;
                this.servingState = this.currentServingState();
                if (lastState != this.servingState) {
                    logger.info("Serving state transformed from {} to {}", (Object)lastState, (Object)this.servingState);
                    if (this.servingState == ServingState.PUSH_PAUSED) {
                        this.pausePushDataCounter.increment();
                        logger.info("Trigger action: PAUSE PUSH, RESUME REPLICATE");
                        this.memoryPressureListeners.forEach(memoryPressureListener -> memoryPressureListener.onPause("push"));
                        this.memoryPressureListeners.forEach(memoryPressureListener -> memoryPressureListener.onResume("replicate"));
                        this.trimAllListeners();
                    } else if (this.servingState == ServingState.PUSH_AND_REPLICATE_PAUSED) {
                        this.pausePushDataAndReplicateCounter.increment();
                        logger.info("Trigger action: PAUSE PUSH and REPLICATE");
                        this.memoryPressureListeners.forEach(memoryPressureListener -> memoryPressureListener.onPause("push"));
                        this.memoryPressureListeners.forEach(memoryPressureListener -> memoryPressureListener.onPause("replicate"));
                        this.trimAllListeners();
                    } else {
                        logger.info("Trigger action: RESUME PUSH and REPLICATE");
                        this.memoryPressureListeners.forEach(memoryPressureListener -> memoryPressureListener.onResume("all"));
                    }
                } else if (this.servingState != ServingState.NONE_PAUSED) {
                    logger.debug("Trigger action: TRIM");
                    this.trimAllListeners();
                }
            }
            catch (Exception e) {
                logger.error("Memory tracker check error", (Throwable)e);
            }
        }, checkInterval, checkInterval, TimeUnit.MILLISECONDS);
        this.reportService.scheduleWithFixedDelay(() -> logger.info("Direct memory usage: {}/{}, disk buffer size: {}, sort memory size: {}, read buffer size: {}", new Object[]{Utils.bytesToString((long)this.getNettyUsedDirectMemory()), Utils.bytesToString((long)this.maxDirectorMemory), Utils.bytesToString((long)this.diskBufferCounter.get()), Utils.bytesToString((long)this.sortMemoryCounter.get()), Utils.bytesToString((long)this.readBufferCounter.get())}), reportInterval, reportInterval, TimeUnit.SECONDS);
        if (this.readBufferThreshold > 0L) {
            this.readBufferDispatcher = new ReadBufferDispatcher(this, conf);
            this.readBufferTargetChangeListeners = new ArrayList<ReadBufferTargetChangeListener>();
            this.readBufferTargetUpdateService.scheduleWithFixedDelay(() -> {
                block6: {
                    try {
                        long currentTarget;
                        int mapDataPartitionCount;
                        if (this.creditStreamManager == null || (mapDataPartitionCount = this.creditStreamManager.getActiveMapPartitionCount()) <= 0 || Math.abs(this.lastNotifiedTarget - (currentTarget = (long)Math.ceil((double)this.readBufferTarget * 1.0 / (double)mapDataPartitionCount))) <= readBufferTargetNotifyThreshold) break block6;
                        List<ReadBufferTargetChangeListener> list = this.readBufferTargetChangeListeners;
                        synchronized (list) {
                            logger.debug("read buffer target changed {} -> {} active map partition count {}", new Object[]{this.lastNotifiedTarget, currentTarget, mapDataPartitionCount});
                            for (ReadBufferTargetChangeListener changeListener : this.readBufferTargetChangeListeners) {
                                changeListener.onChange(currentTarget);
                            }
                            this.lastNotifiedTarget = currentTarget;
                        }
                    }
                    catch (Exception e) {
                        logger.warn("Failed update buffer target", (Throwable)e);
                    }
                }
            }, readBufferTargetUpdateInterval, readBufferTargetUpdateInterval, TimeUnit.MILLISECONDS);
        }
        logger.info("Memory tracker initialized with: max direct memory: {}, pause push memory: {}, pause replication memory: {}, resume memory: {}, read buffer memory limit: {} target: {}, memory shuffle storage limit: {}", new Object[]{Utils.bytesToString((long)this.maxDirectorMemory), Utils.bytesToString((long)this.pausePushDataThreshold), Utils.bytesToString((long)this.pauseReplicateThreshold), Utils.bytesToString((long)this.resumeThreshold), Utils.bytesToString((long)this.readBufferThreshold), Utils.bytesToString((long)this.readBufferTarget), Utils.bytesToString((long)this.memoryShuffleStorageThreshold)});
    }

    public ServingState currentServingState() {
        boolean resume;
        long memoryUsage = this.getMemoryUsage();
        boolean pausePushData = memoryUsage > this.pausePushDataThreshold;
        boolean pauseReplicate = memoryUsage > this.pauseReplicateThreshold;
        boolean bl = resume = memoryUsage < this.resumeThreshold;
        if (pausePushData || pauseReplicate) {
            this.underPressure = true;
        } else if (resume) {
            this.underPressure = false;
        }
        if (pausePushData && pauseReplicate) {
            return ServingState.PUSH_AND_REPLICATE_PAUSED;
        }
        if (pausePushData) {
            return ServingState.PUSH_PAUSED;
        }
        if (resume) {
            return ServingState.NONE_PAUSED;
        }
        if (this.underPressure) {
            return ServingState.PUSH_PAUSED;
        }
        return ServingState.NONE_PAUSED;
    }

    public void trimAllListeners() {
        if (this.trimInProcess.compareAndSet(false, true)) {
            this.actionService.submit(() -> {
                this.memoryPressureListeners.forEach(MemoryPressureListener::onTrim);
                this.trimInProcess.set(false);
            });
        }
    }

    public void reserveSortMemory(long fileLen) {
        this.sortMemoryCounter.addAndGet(fileLen);
    }

    public boolean sortMemoryReady() {
        return this.currentServingState() == ServingState.NONE_PAUSED && this.sortMemoryCounter.get() < this.maxSortMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSortMemory(long size) {
        MemoryManager memoryManager = this;
        synchronized (memoryManager) {
            if (this.sortMemoryCounter.get() - size < 0L) {
                this.sortMemoryCounter.set(0L);
            } else {
                this.sortMemoryCounter.addAndGet(-1L * size);
            }
        }
    }

    public void incrementDiskBuffer(int size) {
        this.diskBufferCounter.addAndGet(size);
    }

    public void releaseDiskBuffer(int size) {
        this.diskBufferCounter.addAndGet(size * -1);
    }

    public long getNettyUsedDirectMemory() {
        long usedDirectMemory = PlatformDependent.usedDirectMemory();
        assert (usedDirectMemory != -1L);
        return usedDirectMemory;
    }

    public long getMemoryUsage() {
        return this.getNettyUsedDirectMemory() + this.sortMemoryCounter.get();
    }

    public AtomicLong getSortMemoryCounter() {
        return this.sortMemoryCounter;
    }

    public AtomicLong getDiskBufferCounter() {
        return this.diskBufferCounter;
    }

    public long getReadBufferCounter() {
        return this.readBufferCounter.get();
    }

    public long getPausePushDataCounter() {
        return this.pausePushDataCounter.sum();
    }

    public void requestReadBuffers(ReadBufferRequest request) {
        this.readBufferDispatcher.addBufferRequest(request);
    }

    public void recycleReadBuffer(ByteBuf readBuf) {
        this.readBufferDispatcher.recycle(readBuf);
    }

    protected void changeReadBufferCounter(int delta) {
        this.readBufferCounter.addAndGet(delta);
    }

    protected boolean readBufferAvailable(int requiredBytes) {
        return this.readBufferCounter.get() + (long)requiredBytes < this.readBufferThreshold;
    }

    public long getPausePushDataAndReplicateCounter() {
        return this.pausePushDataAndReplicateCounter.sum();
    }

    public long getAllocatedReadBuffers() {
        return this.readBufferDispatcher.getAllocatedReadBuffers();
    }

    public int dispatchRequestsLength() {
        return this.readBufferDispatcher.requestsLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReadBufferTargetChangeListener(ReadBufferTargetChangeListener listener) {
        List<ReadBufferTargetChangeListener> list = this.readBufferTargetChangeListeners;
        synchronized (list) {
            this.readBufferTargetChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReadBufferTargetChangeListener(ReadBufferTargetChangeListener listener) {
        List<ReadBufferTargetChangeListener> list = this.readBufferTargetChangeListeners;
        synchronized (list) {
            this.readBufferTargetChangeListeners.remove(listener);
        }
    }

    public void setCreditStreamManager(CreditStreamManager creditStreamManager) {
        this.creditStreamManager = creditStreamManager;
    }

    public void close() {
        this.checkService.shutdown();
        this.reportService.shutdown();
        this.readBufferTargetUpdateService.shutdown();
        this.memoryPressureListeners.clear();
        this.actionService.shutdown();
        this.readBufferTargetChangeListeners.clear();
        this.readBufferDispatcher.close();
    }

    @VisibleForTesting
    public static void reset() {
        _INSTANCE = null;
    }

    static enum ServingState {
        NONE_PAUSED,
        PUSH_AND_REPLICATE_PAUSED,
        PUSH_PAUSED;

    }

    public static interface ReadBufferTargetChangeListener {
        public void onChange(long var1);
    }

    public static interface MemoryPressureListener {
        public void onPause(String var1);

        public void onResume(String var1);

        public void onTrim();
    }
}

