/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.congestcontrol;

import com.google.common.annotations.VisibleForTesting;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.commons.lang3.tuple.Pair;

public abstract class TimeSlidingHub<N extends TimeSlidingNode> {
    protected final int intervalPerBucketInMills = 1000;
    private final int maxQueueSize;
    private Pair<N, Integer> sumInfo;
    private final LinkedBlockingDeque<Pair<Long, N>> _deque = new LinkedBlockingDeque();

    public TimeSlidingHub(int timeWindowsInSecs) {
        this.maxQueueSize = timeWindowsInSecs * 1000 / 1000;
        this.sumInfo = Pair.of(this.newEmptyNode(), (Object)0);
    }

    public Pair<N, Integer> sum() {
        return this.sumInfo;
    }

    public void add(N newNode) {
        long currentTimestamp = this.currentTimeMillis();
        this.add(currentTimestamp, newNode);
    }

    public synchronized void add(long currentTimestamp, N newNode) {
        if (this._deque.size() == 0) {
            this._deque.add(Pair.of((Object)currentTimestamp, (Object)newNode.clone()));
            this.sumInfo = Pair.of((Object)newNode.clone(), (Object)1);
            return;
        }
        Pair lastNode = this._deque.getLast();
        long timeDiff = currentTimestamp - (Long)lastNode.getLeft();
        if (timeDiff >= 1000L) {
            int nodesToAdd = (int)timeDiff / 1000;
            if (nodesToAdd >= this.maxQueueSize) {
                this._deque.clear();
                this._deque.add(Pair.of((Object)currentTimestamp, (Object)newNode.clone()));
                this.sumInfo = Pair.of((Object)newNode.clone(), (Object)1);
                return;
            }
            for (int i = 1; i < nodesToAdd; ++i) {
                N toAdd = this.newEmptyNode();
                lastNode = Pair.of((Object)((Long)lastNode.getLeft() + 1000L), toAdd);
                this._deque.add(lastNode);
            }
            this._deque.add(Pair.of((Object)((Long)lastNode.getLeft() + 1000L), (Object)newNode.clone()));
            TimeSlidingNode nodeToCombine = (TimeSlidingNode)this.sumInfo.getLeft();
            nodeToCombine.combineNode((TimeSlidingNode)newNode);
            this.sumInfo = Pair.of((Object)nodeToCombine, (Object)((Integer)this.sumInfo.getRight() + nodesToAdd));
            while (this._deque.size() > this.maxQueueSize) {
                Pair<Long, N> removed = this._deque.removeFirst();
                TimeSlidingNode nodeToSeparate = (TimeSlidingNode)this.sumInfo.getLeft();
                nodeToSeparate.separateNode((TimeSlidingNode)removed.getRight());
                this.sumInfo = Pair.of((Object)nodeToSeparate, (Object)((Integer)this.sumInfo.getRight() - 1));
            }
            return;
        }
        if (timeDiff < 0L) {
            Iterator<Pair<Long, N>> iter = this._deque.descendingIterator();
            while (iter.hasNext()) {
                Pair<Long, N> curNode = iter.next();
                if (currentTimestamp - (Long)curNode.getLeft() < 0L) continue;
                ((TimeSlidingNode)curNode.getRight()).combineNode((TimeSlidingNode)newNode);
                ((TimeSlidingNode)this.sumInfo.getLeft()).combineNode((TimeSlidingNode)newNode);
                return;
            }
            return;
        }
        ((TimeSlidingNode)lastNode.getRight()).combineNode((TimeSlidingNode)newNode);
        ((TimeSlidingNode)this.sumInfo.getLeft()).combineNode((TimeSlidingNode)newNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedBlockingDeque<Pair<Long, N>> linkedBlockingDeque = this._deque;
        synchronized (linkedBlockingDeque) {
            this._deque.clear();
            this.sumInfo = Pair.of(this.newEmptyNode(), (Object)0);
        }
    }

    protected abstract N newEmptyNode();

    @VisibleForTesting
    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static interface TimeSlidingNode
    extends Cloneable {
        public void combineNode(TimeSlidingNode var1);

        public void separateNode(TimeSlidingNode var1);

        public TimeSlidingNode clone();
    }
}

