/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker;

import com.google.common.base.Throwables;
import io.netty.channel.Channel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.FileInfo;
import org.apache.celeborn.common.meta.FileManagedBuffers;
import org.apache.celeborn.common.meta.TimeWindow;
import org.apache.celeborn.common.network.buffer.ManagedBuffer;
import org.apache.celeborn.common.network.buffer.NioManagedBuffer;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.protocol.BufferStreamEnd;
import org.apache.celeborn.common.network.protocol.ChunkFetchFailure;
import org.apache.celeborn.common.network.protocol.ChunkFetchRequest;
import org.apache.celeborn.common.network.protocol.ChunkFetchSuccess;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.OpenStream;
import org.apache.celeborn.common.network.protocol.OpenStreamWithCredit;
import org.apache.celeborn.common.network.protocol.ReadAddCredit;
import org.apache.celeborn.common.network.protocol.RequestMessage;
import org.apache.celeborn.common.network.protocol.RpcFailure;
import org.apache.celeborn.common.network.protocol.RpcRequest;
import org.apache.celeborn.common.network.protocol.RpcResponse;
import org.apache.celeborn.common.network.protocol.StreamHandle;
import org.apache.celeborn.common.network.server.BaseMessageHandler;
import org.apache.celeborn.common.network.util.NettyUtils;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.protocol.PartitionType;
import org.apache.celeborn.common.util.ExceptionUtils;
import org.apache.celeborn.service.deploy.worker.Worker;
import org.apache.celeborn.service.deploy.worker.WorkerSource;
import org.apache.celeborn.service.deploy.worker.WorkerSource$;
import org.apache.celeborn.service.deploy.worker.storage.ChunkStreamManager;
import org.apache.celeborn.service.deploy.worker.storage.CreditStreamManager;
import org.apache.celeborn.service.deploy.worker.storage.PartitionFilesSorter;
import org.apache.celeborn.service.deploy.worker.storage.StorageManager;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tMb\u0001B\u0012%\u0001EB\u0001B\u0011\u0001\u0003\u0006\u0004%\ta\u0011\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\t\"A\u0011\n\u0001BC\u0002\u0013\u0005!\n\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003L\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u001dA\u0006\u00011A\u0005\u0002eCq\u0001\u0019\u0001A\u0002\u0013\u0005\u0011\r\u0003\u0004k\u0001\u0001\u0006KA\u0017\u0005\bW\u0002\u0011\r\u0011\"\u0001m\u0011\u0019\u0001\b\u0001)A\u0005[\"I\u0011\u000f\u0001a\u0001\u0002\u0004%\tA\u001d\u0005\nm\u0002\u0001\r\u00111A\u0005\u0002]D\u0011\"\u001f\u0001A\u0002\u0003\u0005\u000b\u0015B:\t\u0013i\u0004\u0001\u0019!a\u0001\n\u0003Y\bBC@\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0002!Q\u0011Q\u0001\u0001A\u0002\u0003\u0005\u000b\u0015\u0002?\t\u0017\u0005\u001d\u0001\u00011AA\u0002\u0013\u0005\u0011\u0011\u0002\u0005\f\u0003#\u0001\u0001\u0019!a\u0001\n\u0003\t\u0019\u0002C\u0006\u0002\u0018\u0001\u0001\r\u0011!Q!\n\u0005-\u0001\"CA\r\u0001\u0001\u0007I\u0011AA\u000e\u0011%\t\u0019\u0004\u0001a\u0001\n\u0003\t)\u0004\u0003\u0005\u0002:\u0001\u0001\u000b\u0015BA\u000f\u0011\u001d\tY\u0004\u0001C\u0001\u0003{Aq!a\u0012\u0001\t\u0003\tI\u0005C\u0004\u0002v\u0001!\t%a\u001e\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\"9\u0011q\u0016\u0001\u0005\n\u0005E\u0006bBAh\u0001\u0011\u0005\u0011\u0011\u001b\u0005\b\u0003;\u0004A\u0011AAp\u0011\u001d\tI\u000f\u0001C\u0001\u0003WDq!a>\u0001\t\u0003\nI\u0010C\u0004\u0003\u0002\u0001!\tEa\u0001\t\u000f\t\u001d\u0001\u0001\"\u0011\u0003\n!9!1\u0005\u0001\u0005\u0002\t\u0015\"\u0001\u0004$fi\u000eD\u0007*\u00198eY\u0016\u0014(BA\u0013'\u0003\u00199xN]6fe*\u0011q\u0005K\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005%R\u0013aB:feZL7-\u001a\u0006\u0003W1\n\u0001bY3mK\n|'O\u001c\u0006\u0003[9\na!\u00199bG\",'\"A\u0018\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0011D\b\u0005\u00024u5\tAG\u0003\u00026m\u000511/\u001a:wKJT!a\u000e\u001d\u0002\u000f9,Go^8sW*\u0011\u0011HK\u0001\u0007G>lWn\u001c8\n\u0005m\"$A\u0005\"bg\u0016lUm]:bO\u0016D\u0015M\u001c3mKJ\u0004\"!\u0010!\u000e\u0003yR!a\u0010\u001d\u0002\u0011%tG/\u001a:oC2L!!\u0011 \u0003\u000f1{wmZ5oO\u0006!1m\u001c8g+\u0005!\u0005CA#G\u001b\u0005A\u0014BA$9\u00051\u0019U\r\\3c_Jt7i\u001c8g\u0003\u0015\u0019wN\u001c4!\u00035!(/\u00198ta>\u0014HoQ8oMV\t1\n\u0005\u0002M\u001f6\tQJ\u0003\u0002Om\u0005!Q\u000f^5m\u0013\t\u0001VJA\u0007Ue\u0006t7\u000f]8si\u000e{gNZ\u0001\u000fiJ\fgn\u001d9peR\u001cuN\u001c4!\u0003\u0019a\u0014N\\5u}Q\u0019AKV,\u0011\u0005U\u0003Q\"\u0001\u0013\t\u000b\t+\u0001\u0019\u0001#\t\u000b%+\u0001\u0019A&\u0002%\rDWO\\6TiJ,\u0017-\\'b]\u0006<WM]\u000b\u00025B\u00111LX\u0007\u00029*\u0011Q\fJ\u0001\bgR|'/Y4f\u0013\tyFL\u0001\nDQVt7n\u0015;sK\u0006lW*\u00198bO\u0016\u0014\u0018AF2ik:\\7\u000b\u001e:fC6l\u0015M\\1hKJ|F%Z9\u0015\u0005\tD\u0007CA2g\u001b\u0005!'\"A3\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d$'\u0001B+oSRDq![\u0004\u0002\u0002\u0003\u0007!,A\u0002yIE\n1c\u00195v].\u001cFO]3b[6\u000bg.Y4fe\u0002\n1c\u0019:fI&$8\u000b\u001e:fC6l\u0015M\\1hKJ,\u0012!\u001c\t\u00037:L!a\u001c/\u0003'\r\u0013X\rZ5u'R\u0014X-Y7NC:\fw-\u001a:\u0002)\r\u0014X\rZ5u'R\u0014X-Y7NC:\fw-\u001a:!\u000319xN]6feN{WO]2f+\u0005\u0019\bCA+u\u0013\t)HE\u0001\u0007X_J\\WM]*pkJ\u001cW-\u0001\tx_J\\WM]*pkJ\u001cWm\u0018\u0013fcR\u0011!\r\u001f\u0005\bS2\t\t\u00111\u0001t\u000359xN]6feN{WO]2fA\u0005q1\u000f^8sC\u001e,W*\u00198bO\u0016\u0014X#\u0001?\u0011\u0005mk\u0018B\u0001@]\u00059\u0019Fo\u001c:bO\u0016l\u0015M\\1hKJ\f!c\u001d;pe\u0006<W-T1oC\u001e,'o\u0018\u0013fcR\u0019!-a\u0001\t\u000f%|\u0011\u0011!a\u0001y\u0006y1\u000f^8sC\u001e,W*\u00198bO\u0016\u0014\b%\u0001\tqCJ$\u0018\u000e^5p]N\u001cvN\u001d;feV\u0011\u00111\u0002\t\u00047\u00065\u0011bAA\b9\n!\u0002+\u0019:uSRLwN\u001c$jY\u0016\u001c8k\u001c:uKJ\fA\u0003]1si&$\u0018n\u001c8t'>\u0014H/\u001a:`I\u0015\fHc\u00012\u0002\u0016!A\u0011NEA\u0001\u0002\u0004\tY!A\tqCJ$\u0018\u000e^5p]N\u001cvN\u001d;fe\u0002\n!B]3hSN$XM]3e+\t\ti\u0002\u0005\u0003\u0002 \u0005=RBAA\u0011\u0015\u0011\t\u0019#!\n\u0002\r\u0005$x.\\5d\u0015\u0011\t9#!\u000b\u0002\u0015\r|gnY;se\u0016tGOC\u0002O\u0003WQ!!!\f\u0002\t)\fg/Y\u0005\u0005\u0003c\t\tCA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\u000fe\u0016<\u0017n\u001d;fe\u0016$w\fJ3r)\r\u0011\u0017q\u0007\u0005\tSV\t\t\u00111\u0001\u0002\u001e\u0005Y!/Z4jgR,'/\u001a3!\u0003\u0011Ig.\u001b;\u0015\u0007\t\fy\u0004\u0003\u0004&/\u0001\u0007\u0011\u0011\t\t\u0004+\u0006\r\u0013bAA#I\t1qk\u001c:lKJ\fabZ3u%\u0006<h)\u001b7f\u0013:4w\u000e\u0006\u0004\u0002L\u0005]\u0013\u0011\u000f\t\u0005\u0003\u001b\n\u0019&\u0004\u0002\u0002P)\u0019\u0011\u0011\u000b\u001d\u0002\t5,G/Y\u0005\u0005\u0003+\nyE\u0001\u0005GS2,\u0017J\u001c4p\u0011\u001d\tI\u0006\u0007a\u0001\u00037\n!b\u001d5vM\u001adWmS3z!\u0011\ti&a\u001b\u000f\t\u0005}\u0013q\r\t\u0004\u0003C\"WBAA2\u0015\r\t)\u0007M\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005%D-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003[\nyG\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003S\"\u0007bBA:1\u0001\u0007\u00111L\u0001\tM&dWMT1nK\u00069!/Z2fSZ,G#\u00022\u0002z\u0005\u001d\u0005bBA>3\u0001\u0007\u0011QP\u0001\u0007G2LWM\u001c;\u0011\t\u0005}\u00141Q\u0007\u0003\u0003\u0003S1!a\u001f7\u0013\u0011\t))!!\u0003\u001fQ\u0013\u0018M\\:q_J$8\t\\5f]RDq!!#\u001a\u0001\u0004\tY)A\u0002ng\u001e\u0004B!!$\u0002\u00146\u0011\u0011q\u0012\u0006\u0004\u0003#3\u0014\u0001\u00039s_R|7m\u001c7\n\t\u0005U\u0015q\u0012\u0002\u000f%\u0016\fX/Z:u\u001b\u0016\u001c8/Y4f\u0003AA\u0017M\u001c3mK>\u0003XM\\*ue\u0016\fW\u000eF\u0004c\u00037\u000bi*a*\t\u000f\u0005m$\u00041\u0001\u0002~!9\u0011q\u0014\u000eA\u0002\u0005\u0005\u0016a\u0002:fcV,7\u000f\u001e\t\u0005\u0003\u001b\u000b\u0019+\u0003\u0003\u0002&\u0006=%A\u0003*qGJ+\u0017/^3ti\"9\u0011\u0011\u0012\u000eA\u0002\u0005%\u0006\u0003BAG\u0003WKA!!,\u0002\u0010\n9Q*Z:tC\u001e,\u0017\u0001\u00065b]\u0012dWM\u00159d\u0013>+\u0005pY3qi&|g\u000eF\u0004c\u0003g\u000b),a0\t\u000f\u0005m4\u00041\u0001\u0002~!9\u0011qW\u000eA\u0002\u0005e\u0016!\u0003:fcV,7\u000f^%e!\r\u0019\u00171X\u0005\u0004\u0003{#'\u0001\u0002'p]\u001eDq!!1\u001c\u0001\u0004\t\u0019-A\u0002j_\u0016\u0004B!!2\u0002L6\u0011\u0011q\u0019\u0006\u0005\u0003\u0013\fY#\u0001\u0002j_&!\u0011QZAd\u0005-Iu*\u0012=dKB$\u0018n\u001c8\u00023!\fg\u000e\u001a7f\u000b:$7\u000b\u001e:fC64%o\\7DY&,g\u000e\u001e\u000b\u0004E\u0006M\u0007bBAk9\u0001\u0007\u0011q[\u0001\u0004e\u0016\f\b\u0003BAG\u00033LA!a7\u0002\u0010\ny!)\u001e4gKJ\u001cFO]3b[\u0016sG-A\niC:$G.\u001a*fC\u0012\fE\rZ\"sK\u0012LG\u000fF\u0002c\u0003CDq!!6\u001e\u0001\u0004\t\u0019\u000f\u0005\u0003\u0002\u000e\u0006\u0015\u0018\u0002BAt\u0003\u001f\u0013QBU3bI\u0006#Gm\u0011:fI&$\u0018a\u00065b]\u0012dWm\u00115v].4U\r^2i%\u0016\fX/Z:u)\u0015\u0011\u0017Q^Ax\u0011\u001d\tYH\ba\u0001\u0003{Bq!!6\u001f\u0001\u0004\t\t\u0010\u0005\u0003\u0002\u000e\u0006M\u0018\u0002BA{\u0003\u001f\u0013\u0011c\u00115v].4U\r^2i%\u0016\fX/Z:u\u0003=\u0019\u0007.Z2l%\u0016<\u0017n\u001d;fe\u0016$GCAA~!\r\u0019\u0017Q`\u0005\u0004\u0003\u007f$'a\u0002\"p_2,\u0017M\\\u0001\u0010G\"\fgN\\3m\u0013:\f7\r^5wKR\u0019!M!\u0002\t\u000f\u0005m\u0004\u00051\u0001\u0002~\u0005yQ\r_2faRLwN\\\"bk\u001eDG\u000fF\u0003c\u0005\u0017\u0011\t\u0003C\u0004\u0003\u000e\u0005\u0002\rAa\u0004\u0002\u000b\r\fWo]3\u0011\t\tE!1\u0004\b\u0005\u0005'\u00119B\u0004\u0003\u0002b\tU\u0011\"A3\n\u0007\teA-A\u0004qC\u000e\\\u0017mZ3\n\t\tu!q\u0004\u0002\n)\"\u0014xn^1cY\u0016T1A!\u0007e\u0011\u001d\tY(\ta\u0001\u0003{\n\u0001d\u00197fC:,\b/\u0012=qSJ,Gm\u00155vM\u001adWmS3z)\r\u0011'q\u0005\u0005\b\u0005S\u0011\u0003\u0019\u0001B\u0016\u0003I)\u0007\u0010]5sK\u0012\u001c\u0006.\u001e4gY\u0016\\U-_:\u0011\r\t5\"qFA.\u001b\t\tI#\u0003\u0003\u00032\u0005%\"a\u0002%bg\"\u001cV\r\u001e")
public class FetchHandler
extends BaseMessageHandler
implements Logging {
    private final CelebornConf conf;
    private final TransportConf transportConf;
    private ChunkStreamManager chunkStreamManager;
    private final CreditStreamManager creditStreamManager;
    private WorkerSource workerSource;
    private StorageManager storageManager;
    private PartitionFilesSorter partitionsSorter;
    private AtomicBoolean registered;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        FetchHandler fetchHandler = this;
        synchronized (fetchHandler) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public CelebornConf conf() {
        return this.conf;
    }

    public TransportConf transportConf() {
        return this.transportConf;
    }

    public ChunkStreamManager chunkStreamManager() {
        return this.chunkStreamManager;
    }

    public void chunkStreamManager_$eq(ChunkStreamManager x$1) {
        this.chunkStreamManager = x$1;
    }

    public CreditStreamManager creditStreamManager() {
        return this.creditStreamManager;
    }

    public WorkerSource workerSource() {
        return this.workerSource;
    }

    public void workerSource_$eq(WorkerSource x$1) {
        this.workerSource = x$1;
    }

    public StorageManager storageManager() {
        return this.storageManager;
    }

    public void storageManager_$eq(StorageManager x$1) {
        this.storageManager = x$1;
    }

    public PartitionFilesSorter partitionsSorter() {
        return this.partitionsSorter;
    }

    public void partitionsSorter_$eq(PartitionFilesSorter x$1) {
        this.partitionsSorter = x$1;
    }

    public AtomicBoolean registered() {
        return this.registered;
    }

    public void registered_$eq(AtomicBoolean x$1) {
        this.registered = x$1;
    }

    public void init(Worker worker) {
        this.workerSource_$eq(worker.workerSource());
        WorkerSource qual$1 = this.workerSource();
        String x$1 = WorkerSource$.MODULE$.CREDIT_STREAM_COUNT();
        Map x$2 = qual$1.addGauge$default$2();
        JFunction0.mcJ.sp & Serializable & scala.Serializable x$3 = (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.creditStreamManager().getStreamsCount();
        qual$1.addGauge(x$1, x$2, (Function0)x$3);
        WorkerSource qual$2 = this.workerSource();
        String x$4 = WorkerSource$.MODULE$.ACTIVE_MAP_PARTITION_COUNT();
        Map x$5 = qual$2.addGauge$default$2();
        JFunction0.mcI.sp & Serializable & scala.Serializable x$6 = (JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.creditStreamManager().getActiveMapPartitionCount();
        qual$2.addGauge(x$4, x$5, (Function0)x$6);
        this.storageManager_$eq(worker.storageManager());
        this.partitionsSorter_$eq(worker.partitionsSorter());
        this.registered_$eq(worker.registered());
    }

    /*
     * WARNING - void declaration
     */
    public FileInfo getRawFileInfo(String shuffleKey, String fileName) {
        void var3_3;
        FileInfo fileInfo = this.storageManager().getFileInfo(shuffleKey, fileName);
        if (fileInfo == null) {
            String errMsg = new StringBuilder(26).append("Could not find file ").append(fileName).append(" for ").append(shuffleKey).append(".").toString();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errMsg);
            throw new FileNotFoundException(errMsg);
        }
        return var3_3;
    }

    public void receive(TransportClient client, RequestMessage msg) {
        RequestMessage requestMessage = msg;
        if (requestMessage instanceof BufferStreamEnd) {
            BufferStreamEnd bufferStreamEnd = (BufferStreamEnd)requestMessage;
            this.handleEndStreamFromClient(bufferStreamEnd);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (requestMessage instanceof ReadAddCredit) {
            ReadAddCredit readAddCredit = (ReadAddCredit)requestMessage;
            this.handleReadAddCredit(readAddCredit);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (requestMessage instanceof ChunkFetchRequest) {
            ChunkFetchRequest chunkFetchRequest = (ChunkFetchRequest)requestMessage;
            this.handleChunkFetchRequest(client, chunkFetchRequest);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (requestMessage instanceof RpcRequest) {
            RpcRequest rpcRequest = (RpcRequest)requestMessage;
            Message msg2 = Message.decode((ByteBuffer)rpcRequest.body().nioByteBuffer());
            this.handleOpenStream(client, rpcRequest, msg2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (requestMessage != null) {
                RequestMessage requestMessage2 = requestMessage;
                throw new IllegalArgumentException(new StringBuilder(25).append("Unknown message type id: ").append(requestMessage2.type().id()).toString());
            }
            throw new MatchError((Object)requestMessage);
        }
    }

    public void handleOpenStream(TransportClient client, RpcRequest request, Message msg) {
        block18: {
            Tuple2 tuple2;
            Tuple2 tuple22;
            Message.Type type = msg.type();
            Message.Type type2 = Message.Type.OPEN_STREAM;
            if (!(type != null ? !type.equals(type2) : type2 != null)) {
                OpenStream openStream = (OpenStream)msg;
                tuple22 = new Tuple2((Object)new String(openStream.shuffleKey, StandardCharsets.UTF_8), (Object)new String(openStream.fileName, StandardCharsets.UTF_8));
            } else {
                OpenStreamWithCredit openStreamWithCredit = (OpenStreamWithCredit)msg;
                tuple22 = tuple2 = new Tuple2((Object)new String(openStreamWithCredit.shuffleKey, StandardCharsets.UTF_8), (Object)new String(openStreamWithCredit.fileName, StandardCharsets.UTF_8));
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String shuffleKey = (String)tuple2._1();
            String fileName = (String)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)shuffleKey, (Object)fileName);
            Tuple2 tuple24 = tuple23;
            String shuffleKey2 = (String)tuple24._1();
            String fileName2 = (String)tuple24._2();
            this.workerSource().startTimer(WorkerSource$.MODULE$.OPEN_STREAM_TIME(), shuffleKey2);
            try {
                ObjectRef fileInfo = ObjectRef.create((Object)this.getRawFileInfo(shuffleKey2, fileName2));
                try {
                    try {
                        PartitionType partitionType = ((FileInfo)fileInfo.elem).getPartitionType();
                        if (PartitionType.REDUCE.equals(partitionType)) {
                            BoxedUnit boxedUnit;
                            int startMapIndex = ((OpenStream)msg).startMapIndex;
                            int endMapIndex = ((OpenStream)msg).endMapIndex;
                            if (endMapIndex != Integer.MAX_VALUE) {
                                fileInfo.elem = this.partitionsSorter().getSortedFileInfo(shuffleKey2, fileName2, (FileInfo)fileInfo.elem, startMapIndex, endMapIndex);
                            }
                            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Received chunk fetch request ").append(shuffleKey2).append(" ").append(fileName2).append(" ").append(startMapIndex).append(" ").append(endMapIndex).append(" get file info ").append((FileInfo)fileInfo$1.elem).toString());
                            if (((FileInfo)fileInfo.elem).isHdfs()) {
                                StreamHandle streamHandle = new StreamHandle(0L, 0);
                                client.getChannel().writeAndFlush((Object)new RpcResponse(request.requestId, (ManagedBuffer)new NioManagedBuffer(streamHandle.toByteBuffer())));
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                FileManagedBuffers buffers = new FileManagedBuffers((FileInfo)fileInfo.elem, this.transportConf());
                                TimeWindow fetchTimeMetrics = this.storageManager().getFetchTimeMetric(((FileInfo)fileInfo.elem).getFile());
                                long streamId = this.chunkStreamManager().registerStream(shuffleKey2, buffers, fetchTimeMetrics);
                                StreamHandle streamHandle = new StreamHandle(streamId, ((FileInfo)fileInfo.elem).numChunks());
                                if (((FileInfo)fileInfo.elem).numChunks() == 0) {
                                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("StreamId ").append(streamId).append(" fileName ").append(fileName2).append(" startMapIndex").append(" ").append(startMapIndex).append(" endMapIndex ").append(endMapIndex).append(" is empty.").toString());
                                } else {
                                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("StreamId ").append(streamId).append(" fileName ").append(fileName2).append(" numChunks ").append(((FileInfo)fileInfo$1.elem).numChunks()).append(" ").append("startMapIndex ").append(startMapIndex).append(" endMapIndex ").append(endMapIndex).toString());
                                }
                                client.getChannel().writeAndFlush((Object)new RpcResponse(request.requestId, (ManagedBuffer)new NioManagedBuffer(streamHandle.toByteBuffer())));
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                            break block18;
                        }
                        if (PartitionType.MAP.equals(partitionType)) {
                            int initialCredit = ((OpenStreamWithCredit)msg).initialCredit;
                            int startIndex = ((OpenStreamWithCredit)msg).startIndex;
                            int endIndex = ((OpenStreamWithCredit)msg).endIndex;
                            Consumer<Long> callback = new Consumer<Long>(null, client, request){
                                private final TransportClient client$1;
                                private final RpcRequest request$1;

                                public Consumer<Long> andThen(Consumer<? super Long> x$1) {
                                    return Consumer.super.andThen(x$1);
                                }

                                public void accept(Long streamId) {
                                    StreamHandle bufferStreamHandle = new StreamHandle(Predef$.MODULE$.Long2long(streamId), 0);
                                    this.client$1.getChannel().writeAndFlush((Object)new RpcResponse(this.request$1.requestId, (ManagedBuffer)new NioManagedBuffer(bufferStreamHandle.toByteBuffer())));
                                }
                                {
                                    this.client$1 = client$1;
                                    this.request$1 = request$1;
                                }
                            };
                            this.creditStreamManager().registerStream(callback, client.getChannel(), initialCredit, startIndex, endIndex, (FileInfo)fileInfo.elem);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block18;
                        }
                        if (PartitionType.MAPGROUP.equals(partitionType)) {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block18;
                        }
                        throw new MatchError((Object)partitionType);
                    }
                    catch (IOException e) {
                        this.handleRpcIOException(client, request.requestId, e);
                    }
                }
                finally {
                    this.workerSource().stopTimer(WorkerSource$.MODULE$.OPEN_STREAM_TIME(), shuffleKey2);
                    request.body().release();
                }
            }
            catch (IOException ioe) {
                this.workerSource().stopTimer(WorkerSource$.MODULE$.OPEN_STREAM_TIME(), shuffleKey2);
                this.handleRpcIOException(client, request.requestId, ioe);
            }
        }
    }

    private void handleRpcIOException(TransportClient client, long requestId, IOException ioe) {
        client.getChannel().writeAndFlush((Object)new RpcFailure(requestId, Throwables.getStackTraceAsString((Throwable)ExceptionUtils.wrapIOExceptionToUnRetryable((Throwable)ioe, (boolean)false))));
    }

    public void handleEndStreamFromClient(BufferStreamEnd req) {
        this.creditStreamManager().notifyStreamEndByClient(req.getStreamId());
    }

    public void handleReadAddCredit(ReadAddCredit req) {
        this.creditStreamManager().addCredit(req.getCredit(), req.getStreamId());
    }

    public void handleChunkFetchRequest(TransportClient client, ChunkFetchRequest req) {
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Received req from ").append(NettyUtils.getRemoteAddress((Channel)client.getChannel())).append(" to fetch block ").append(req$1.streamChunkSlice).toString());
        long chunksBeingTransferred = this.chunkStreamManager().chunksBeingTransferred();
        if (chunksBeingTransferred > this.conf().shuffleIoMaxChunksBeingTransferred()) {
            String message = new StringBuilder(112).append("Worker is too busy. The number of chunks being transferred ").append(chunksBeingTransferred).append(" exceeds celeborn.shuffle.maxChunksBeingTransferred ").append(this.conf().shuffleIoMaxChunksBeingTransferred()).append(".").toString();
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            client.getChannel().writeAndFlush((Object)new ChunkFetchFailure(req.streamChunkSlice, message));
        } else {
            this.workerSource().startTimer(WorkerSource$.MODULE$.FETCH_CHUNK_TIME(), req.toString());
            TimeWindow fetchTimeMetric = this.chunkStreamManager().getFetchTimeMetric(req.streamChunkSlice.streamId);
            long fetchBeginTime = System.nanoTime();
            try {
                ManagedBuffer buf = this.chunkStreamManager().getChunk(req.streamChunkSlice.streamId, req.streamChunkSlice.chunkIndex, req.streamChunkSlice.offset, req.streamChunkSlice.len);
                this.chunkStreamManager().chunkBeingSent(req.streamChunkSlice.streamId);
                client.getChannel().writeAndFlush((Object)new ChunkFetchSuccess(req.streamChunkSlice, buf)).addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(this, req, fetchTimeMetric, fetchBeginTime){
                    private final /* synthetic */ FetchHandler $outer;
                    private final ChunkFetchRequest req$1;
                    private final TimeWindow fetchTimeMetric$1;
                    private final long fetchBeginTime$1;

                    public void operationComplete(Future<? super Void> future) {
                        this.$outer.chunkStreamManager().chunkSent(this.req$1.streamChunkSlice.streamId);
                        if (this.fetchTimeMetric$1 != null) {
                            this.fetchTimeMetric$1.update(System.nanoTime() - this.fetchBeginTime$1);
                        }
                        this.$outer.workerSource().stopTimer(WorkerSource$.MODULE$.FETCH_CHUNK_TIME(), this.req$1.toString());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.req$1 = req$1;
                        this.fetchTimeMetric$1 = fetchTimeMetric$1;
                        this.fetchBeginTime$1 = fetchBeginTime$1;
                    }
                });
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error opening block ").append(req$1.streamChunkSlice).append(" for request from ").append(NettyUtils.getRemoteAddress((Channel)client.getChannel())).toString(), e);
                client.getChannel().writeAndFlush((Object)new ChunkFetchFailure(req.streamChunkSlice, Throwables.getStackTraceAsString((Throwable)e)));
                this.workerSource().stopTimer(WorkerSource$.MODULE$.FETCH_CHUNK_TIME(), req.toString());
            }
        }
    }

    public boolean checkRegistered() {
        return this.registered().get();
    }

    public void channelInactive(TransportClient client) {
        this.creditStreamManager().connectionTerminated(client.getChannel());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("channel inactive ").append(client.getSocketAddress()).toString());
    }

    public void exceptionCaught(Throwable cause, TransportClient client) {
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("exception caught ").append(client.getSocketAddress()).toString(), cause);
    }

    public void cleanupExpiredShuffleKey(HashSet<String> expiredShuffleKeys) {
        this.chunkStreamManager().cleanupExpiredShuffleKey(expiredShuffleKeys);
    }

    public FetchHandler(CelebornConf conf, TransportConf transportConf) {
        this.conf = conf;
        this.transportConf = transportConf;
        Logging.$init$((Logging)this);
        this.chunkStreamManager = new ChunkStreamManager();
        this.creditStreamManager = new CreditStreamManager(conf.partitionReadBuffersMin(), conf.partitionReadBuffersMax(), conf.creditStreamThreadsPerMountpoint(), conf.readBuffersToTriggerReadMin());
        this.registered = new AtomicBoolean(false);
    }
}

