/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink.readclient;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.network.client.RpcResponseCallback;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.protocol.BufferStreamEnd;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.OpenStreamWithCredit;
import org.apache.celeborn.common.network.protocol.ReadAddCredit;
import org.apache.celeborn.common.network.protocol.RequestMessage;
import org.apache.celeborn.common.network.protocol.StreamHandle;
import org.apache.celeborn.common.network.protocol.TransportableError;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.plugin.flink.network.FlinkTransportClientFactory;
import org.apache.celeborn.plugin.flink.readclient.FlinkShuffleClientImpl;
import org.apache.celeborn.shaded.io.netty.util.concurrent.Future;
import org.apache.celeborn.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CelebornBufferStream {
    private static Logger logger = LoggerFactory.getLogger(CelebornBufferStream.class);
    private CelebornConf conf;
    private FlinkTransportClientFactory clientFactory;
    private String shuffleKey;
    private PartitionLocation[] locations;
    private int subIndexStart;
    private int subIndexEnd;
    private TransportClient client;
    private int currentLocationIndex = 0;
    private long streamId = 0L;
    private FlinkShuffleClientImpl mapShuffleClient;
    private boolean isClosed;
    private boolean isOpenSuccess;
    private Object lock = new Object();
    private static final CelebornBufferStream EMPTY_CELEBORN_BUFFER_STREAM = new CelebornBufferStream();

    public CelebornBufferStream() {
    }

    public CelebornBufferStream(FlinkShuffleClientImpl mapShuffleClient, CelebornConf conf, FlinkTransportClientFactory dataClientFactory, String shuffleKey, PartitionLocation[] locations, int subIndexStart, int subIndexEnd) {
        this.mapShuffleClient = mapShuffleClient;
        this.conf = conf;
        this.clientFactory = dataClientFactory;
        this.shuffleKey = shuffleKey;
        this.locations = locations;
        this.subIndexStart = subIndexStart;
        this.subIndexEnd = subIndexEnd;
    }

    public void open(final Supplier<ByteBuf> supplier, int initialCredit, final Consumer<RequestMessage> messageConsumer) throws IOException, InterruptedException {
        this.client = this.clientFactory.createClientWithRetry(this.locations[this.currentLocationIndex].getHost(), this.locations[this.currentLocationIndex].getFetchPort());
        final String fileName = this.locations[this.currentLocationIndex].getFileName();
        OpenStreamWithCredit openBufferStream = new OpenStreamWithCredit(this.shuffleKey, fileName, this.subIndexStart, this.subIndexEnd, initialCredit);
        this.client.sendRpc(openBufferStream.toByteBuffer(), new RpcResponseCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(ByteBuffer response) {
                StreamHandle streamHandle = (StreamHandle)Message.decode(response);
                CelebornBufferStream.this.streamId = streamHandle.streamId;
                Object object = CelebornBufferStream.this.lock;
                synchronized (object) {
                    if (!CelebornBufferStream.this.isClosed) {
                        CelebornBufferStream.this.clientFactory.registerSupplier(CelebornBufferStream.this.streamId, supplier);
                        CelebornBufferStream.this.mapShuffleClient.getReadClientHandler().registerHandler(CelebornBufferStream.this.streamId, messageConsumer, CelebornBufferStream.this.client);
                        CelebornBufferStream.this.isOpenSuccess = true;
                        logger.debug("open stream success from remote:{}, stream id:{}, fileName: {}", new Object[]{CelebornBufferStream.this.client.getSocketAddress(), CelebornBufferStream.this.streamId, fileName});
                    } else {
                        logger.debug("open stream success from remote:{}, but stream reader is already closed, stream id:{}, fileName: {}", new Object[]{CelebornBufferStream.this.client.getSocketAddress(), CelebornBufferStream.this.streamId, fileName});
                        CelebornBufferStream.this.closeStream();
                    }
                }
            }

            @Override
            public void onFailure(Throwable e) {
                messageConsumer.accept(new TransportableError(CelebornBufferStream.this.streamId, e));
            }
        });
    }

    public void addCredit(ReadAddCredit addCredit) {
        this.client.getChannel().writeAndFlush(addCredit).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
            if (!future.isSuccess()) {
                logger.warn("Send ReadAddCredit to {} failed, detail {}", (Object)this.client.getSocketAddress().toString(), (Object)future.cause());
            }
        }));
    }

    public static CelebornBufferStream empty() {
        return EMPTY_CELEBORN_BUFFER_STREAM;
    }

    public long getStreamId() {
        return this.streamId;
    }

    public static CelebornBufferStream create(FlinkShuffleClientImpl client, CelebornConf conf, FlinkTransportClientFactory dataClientFactory, String shuffleKey, PartitionLocation[] locations, int subIndexStart, int subIndexEnd) {
        if (locations == null || locations.length == 0) {
            return CelebornBufferStream.empty();
        }
        return new CelebornBufferStream(client, conf, dataClientFactory, shuffleKey, locations, subIndexStart, subIndexEnd);
    }

    private void closeStream() {
        if (this.client != null && this.client.isActive()) {
            this.client.getChannel().writeAndFlush(new BufferStreamEnd(this.streamId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpenSuccess) {
                this.mapShuffleClient.getReadClientHandler().removeHandler(this.getStreamId());
                this.clientFactory.unregisterSupplier(this.getStreamId());
                this.closeStream();
            }
            this.isClosed = true;
        }
    }
}

