/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.has.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import org.apache.hadoop.shaded.org.apache.kerby.has.common.HasConfig;
import org.apache.hadoop.shaded.org.apache.kerby.has.common.HasException;
import org.apache.hadoop.shaded.org.apache.kerby.has.common.util.URLConnectionFactory;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;

public class HasClientUtil {
    public static HttpURLConnection getHttpsConnection(HasConfig hasConfig, URL url, boolean isSpnego) throws Exception {
        HasConfig conf = new HasConfig();
        conf.setString("hadoop.ssl.hostname.verifier", "ALLOW_ALL");
        String sslClientConf = hasConfig.getSslClientConf();
        File sslClientConfFile = new File(sslClientConf);
        if (!sslClientConfFile.exists()) {
            throw new HasException("The ssl client config file " + sslClientConf + " does not exist.");
        }
        conf.setString("hadoop.ssl.client.conf", sslClientConf);
        conf.setBoolean("hadoop.ssl.require.client.CERT", (Boolean)false);
        URLConnectionFactory connectionFactory = URLConnectionFactory.newDefaultURLConnectionFactory(conf);
        return (HttpURLConnection)connectionFactory.openConnection(url, isSpnego, hasConfig);
    }

    public static HttpURLConnection createConnection(HasConfig hasConfig, URL url, String method, boolean isSpnego) throws KrbException {
        HttpURLConnection conn = null;
        if (hasConfig.getHttpsPort() != null && hasConfig.getHttpsHost() != null) {
            try {
                conn = HasClientUtil.getHttpsConnection(hasConfig, url, isSpnego);
            }
            catch (Exception e) {
                throw new KrbException("Error occurred when creating https connection. " + e.getMessage());
            }
        }
        if (conn == null) {
            throw new KrbException("Error occurred when creating https connection.");
        }
        try {
            conn.setRequestMethod(method);
        }
        catch (ProtocolException e) {
            throw new KrbException("Failed to set the method for URL request.", (Throwable)e);
        }
        if (method.equals("POST") || method.equals("PUT")) {
            conn.setDoOutput(true);
        }
        conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        return conn;
    }

    public static String getBaseUrl(HasConfig hasConfig, String input) throws KrbException {
        String url = null;
        if (hasConfig.getHttpsPort() != null && hasConfig.getHttpsHost() != null) {
            url = "https://" + hasConfig.getHttpsHost() + ":" + hasConfig.getHttpsPort() + "/has/v1/" + input + "/";
        }
        if (url == null) {
            throw new KrbException("Please set the https address and port.");
        }
        return url;
    }

    public static String getResponse(HttpURLConnection httpConn) throws IOException {
        StringBuilder data = new StringBuilder();
        InputStream inputStream = HasClientUtil.getInputStream(httpConn);
        if (inputStream == null) {
            throw new IOException("Failed to get the InputStream");
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
            String s2;
            while ((s2 = br.readLine()) != null) {
                data.append(s2);
                data.append(System.getProperty("line.separator"));
            }
            String string = data.toString();
            return string;
        }
    }

    public static InputStream getInputStream(HttpURLConnection httpConn) throws IOException {
        InputStream inputStream = httpConn.getResponseCode() < 400 ? httpConn.getInputStream() : httpConn.getErrorStream();
        return inputStream;
    }
}

