/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Chars;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Hex;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Strings {
    private static final Logger LOG = LoggerFactory.getLogger(Strings.class);
    public static final byte[] HEX_CHAR = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final boolean[] IS_PRINTABLE_CHAR = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, true, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    private static final char[] TO_LOWER_CASE = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0086', '\u0087', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u008d', '\u008e', '\u008f', '\u0090', '\u0091', '\u0092', '\u0093', '\u0094', '\u0095', '\u0096', '\u0097', '\u0098', '\u0099', '\u009a', '\u009b', '\u009c', '\u009d', '\u009e', '\u009f', '\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};
    private static final byte[] TO_LOWER_CASE_BYTE = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, -128, -127, -126, -125, -124, -123, -122, -121, -120, -119, -118, -117, -116, -115, -114, -113, -112, -111, -110, -109, -108, -107, -106, -105, -104, -103, -102, -101, -100, -99, -98, -97, -96, -95, -94, -93, -92, -91, -90, -89, -88, -87, -86, -85, -84, -83, -82, -81, -80, -79, -78, -77, -76, -75, -74, -73, -72, -71, -70, -69, -68, -67, -66, -65, -64, -63, -62, -61, -60, -59, -58, -57, -56, -55, -54, -53, -52, -51, -50, -49, -48, -47, -46, -45, -44, -43, -42, -41, -40, -39, -38, -37, -36, -35, -34, -33, -32, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, -5, -4, -3, -2, -1};
    private static final char[] UPPER_CASE = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '-', '\u0000', '\u0000', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    private static final byte[] UTF8 = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127};
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final String EMPTY_STRING = "";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    private Strings() {
    }

    public static String dumpBytes(byte[] buffer) {
        if (buffer == null) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < buffer.length; ++i) {
            sb.append("0x").append((char)HEX_CHAR[(buffer[i] & 0xF0) >> 4]).append((char)HEX_CHAR[buffer[i] & 0xF]).append(" ");
        }
        return sb.toString();
    }

    public static String byteToString(byte b) {
        return Strings.utf8ToString(new byte[]{HEX_CHAR[(b & 0xF0) >> 4], HEX_CHAR[b & 0xF]});
    }

    public static String dumpByte(byte octet) {
        return Strings.utf8ToString(new byte[]{48, 120, HEX_CHAR[(octet & 0xF0) >> 4], HEX_CHAR[octet & 0xF]});
    }

    public static char dumpHex(byte hex) {
        return (char)HEX_CHAR[hex & 0xF];
    }

    public static String dumpHexPairs(byte[] buffer) {
        if (buffer == null) {
            return EMPTY_STRING;
        }
        char[] str = new char[buffer.length << 1];
        int pos = 0;
        for (int i = 0; i < buffer.length; ++i) {
            str[pos++] = (char)HEX_CHAR[(buffer[i] & 0xF0) >> 4];
            str[pos++] = (char)HEX_CHAR[buffer[i] & 0xF];
        }
        return new String(str);
    }

    public static String deepTrim(String str, boolean toLowerCase) {
        if (null == str || str.length() == 0) {
            return EMPTY_STRING;
        }
        int length = str.length();
        char[] newbuf = new char[length];
        boolean wsSeen = false;
        boolean isStart = true;
        int pos = 0;
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (toLowerCase && Character.isUpperCase(ch)) {
                ch = Character.toLowerCase(ch);
            }
            if (Character.isWhitespace(ch)) {
                if (wsSeen) continue;
                wsSeen = true;
                if (isStart) {
                    isStart = false;
                    continue;
                }
                newbuf[pos++] = ch;
                continue;
            }
            wsSeen = false;
            isStart = false;
            newbuf[pos++] = ch;
        }
        return pos == 0 ? EMPTY_STRING : new String(newbuf, 0, wsSeen ? pos - 1 : pos);
    }

    public static String deepTrimToLower(String string) {
        return Strings.deepTrim(string, true);
    }

    public static String deepTrim(String string) {
        return Strings.deepTrim(string, false);
    }

    public static String trimConsecutiveToOne(String str, char ch) {
        if (null == str || str.length() == 0) {
            return EMPTY_STRING;
        }
        char[] buffer = str.toCharArray();
        char[] newbuf = new char[buffer.length];
        int pos = 0;
        boolean same = false;
        for (int i = 0; i < buffer.length; ++i) {
            char car = buffer[i];
            if (car == ch) {
                if (same) continue;
                same = true;
                newbuf[pos++] = car;
                continue;
            }
            same = false;
            newbuf[pos++] = car;
        }
        return new String(newbuf, 0, pos);
    }

    public static String centerTrunc(String str, int head, int tail) {
        if (str.length() <= head + tail + 7 + str.length() / 10) {
            return str;
        }
        StringBuilder buf = new StringBuilder();
        buf.append('[').append(str.length()).append("][");
        buf.append(str.substring(0, head)).append("...");
        buf.append(str.substring(str.length() - tail));
        buf.append(']');
        return buf.toString();
    }

    public static String toHexString(byte[] res) {
        StringBuilder buf = new StringBuilder(res.length << 1);
        for (int ii = 0; ii < res.length; ++ii) {
            String digit = Integer.toHexString(0xFF & res[ii]);
            if (digit.length() == 1) {
                digit = '0' + digit;
            }
            buf.append(digit);
        }
        return Strings.upperCase(buf.toString());
    }

    public static byte[] toByteArray(String hexString) {
        int arrLength = hexString.length() >> 1;
        byte[] buf = new byte[arrLength];
        for (int ii = 0; ii < arrLength; ++ii) {
            int index = ii << 1;
            String digit = hexString.substring(index, index + 2);
            buf[ii] = (byte)Integer.parseInt(digit, 16);
        }
        return buf;
    }

    public static String formatHtml(String source, boolean replaceNl, boolean replaceTag, boolean replaceQuote) {
        StringBuilder buf = new StringBuilder();
        int len = source.length();
        block8: for (int i = 0; i < len; ++i) {
            char ch = source.charAt(i);
            switch (ch) {
                case '\"': {
                    if (replaceQuote) {
                        buf.append("&quot;");
                        continue block8;
                    }
                    buf.append(ch);
                    continue block8;
                }
                case '<': {
                    if (replaceTag) {
                        buf.append("&lt;");
                        continue block8;
                    }
                    buf.append(ch);
                    continue block8;
                }
                case '>': {
                    if (replaceTag) {
                        buf.append("&gt;");
                        continue block8;
                    }
                    buf.append(ch);
                    continue block8;
                }
                case '\n': {
                    if (replaceNl) {
                        if (replaceTag) {
                            buf.append("&lt;br&gt;");
                            continue block8;
                        }
                        buf.append("<br>");
                        continue block8;
                    }
                    buf.append(ch);
                    continue block8;
                }
                case '\r': {
                    continue block8;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block8;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    public static boolean areEquals(String string, int index, String text) {
        if (string == null || text == null) {
            return false;
        }
        int length1 = string.length();
        int length2 = text.length();
        if (length1 == 0 || length1 <= index || index < 0 || length2 == 0 || length2 > length1 + index) {
            return false;
        }
        return string.substring(index).startsWith(text);
    }

    public static boolean isCharASCII(byte[] byteArray, int index, char car) {
        if (byteArray == null || byteArray.length == 0 || index < 0 || index >= byteArray.length) {
            return false;
        }
        return byteArray[index] == car;
    }

    public static boolean isCharASCII(char[] charArray, int index, char car) {
        if (charArray == null || charArray.length == 0 || index < 0 || index >= charArray.length) {
            return false;
        }
        return charArray[index] == car;
    }

    public static boolean isCharASCII(String string, int index, char car) {
        if (string == null) {
            return false;
        }
        int length = string.length();
        if (length == 0 || index < 0 || index >= length) {
            return false;
        }
        return string.charAt(index) == car;
    }

    public static String utf8ToString(byte[] bytes) {
        if (bytes == null) {
            return EMPTY_STRING;
        }
        char[] chars = new char[bytes.length];
        int pos = 0;
        try {
            for (byte b : bytes) {
                chars[pos++] = (char)UTF8[b];
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return new String(bytes, StandardCharsets.UTF_8);
        }
        return new String(chars);
    }

    public static String utf8ToString(byte[] bytes, int length) {
        if (bytes == null) {
            return EMPTY_STRING;
        }
        return new String(bytes, 0, length, StandardCharsets.UTF_8);
    }

    public static String utf8ToString(byte[] bytes, int start, int length) {
        if (bytes == null) {
            return EMPTY_STRING;
        }
        return new String(bytes, start, length, StandardCharsets.UTF_8);
    }

    public static int areEquals(byte[] bytes, int index, String text) {
        if (bytes == null || bytes.length == 0 || bytes.length <= index || index < 0 || text == null) {
            return -1;
        }
        byte[] data = text.getBytes(StandardCharsets.UTF_8);
        return Strings.areEquals(bytes, index, data);
    }

    public static int areEquals(char[] chars, int index, String text) {
        return Strings.areEquals(chars, index, text, true);
    }

    public static int areEquals(char[] chars, int index, String text, boolean caseSensitive) {
        if (chars == null || chars.length == 0 || chars.length <= index || index < 0 || text == null) {
            return -1;
        }
        char[] data = text.toCharArray();
        return Strings.areEquals(chars, index, data, caseSensitive);
    }

    public static int areEquals(char[] chars, int index, char[] chars2) {
        return Strings.areEquals(chars, index, chars2, true);
    }

    public static int areEquals(char[] chars, int index, char[] chars2, boolean caseSensitive) {
        if (chars == null || chars.length == 0 || chars.length <= index || index < 0 || chars2 == null || chars2.length == 0 || chars2.length > chars.length - index) {
            return -1;
        }
        for (int i = 0; i < chars2.length; ++i) {
            char c1 = chars[index++];
            char c2 = chars2[i];
            if (!caseSensitive) {
                c1 = Character.toLowerCase(c1);
                c2 = Character.toLowerCase(c2);
            }
            if (c1 == c2) continue;
            return -1;
        }
        return index;
    }

    public static int areEquals(byte[] bytes, int index, byte[] bytes2) {
        if (bytes == null || bytes.length == 0 || bytes.length <= index || index < 0 || bytes2 == null || bytes2.length == 0 || bytes2.length > bytes.length - index) {
            return -1;
        }
        for (int i = 0; i < bytes2.length; ++i) {
            if (bytes[index++] == bytes2[i]) continue;
            return -1;
        }
        return index;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty(byte[] bytes) {
        return bytes == null || bytes.length == 0;
    }

    public static String trim(String str) {
        return Strings.isEmpty(str) ? EMPTY_STRING : str.trim();
    }

    public static byte[] trim(byte[] bytes) {
        if (Strings.isEmpty(bytes)) {
            return EMPTY_BYTES;
        }
        int start = Strings.trimLeft(bytes, 0);
        int end = Strings.trimRight(bytes, bytes.length - 1);
        int length = end - start + 1;
        if (length != 0) {
            byte[] newBytes = new byte[end - start + 1];
            System.arraycopy(bytes, start, newBytes, 0, length);
            return newBytes;
        }
        return EMPTY_BYTES;
    }

    public static String trimLeft(String str) {
        int start;
        if (Strings.isEmpty(str)) {
            return EMPTY_STRING;
        }
        int end = str.length();
        for (start = 0; start < end && str.charAt(start) == ' '; ++start) {
        }
        return start == 0 ? str : str.substring(start);
    }

    public static int trimLeft(char[] chars, int pos) {
        if (chars == null) {
            return pos;
        }
        while (pos < chars.length && chars[pos] == ' ') {
            ++pos;
        }
        return pos;
    }

    public static void trimLeft(String string, Position pos) {
        if (string == null) {
            return;
        }
        int length = string.length();
        while (pos.start < length && string.charAt(pos.start) == ' ') {
            ++pos.start;
        }
        pos.end = pos.start;
    }

    public static void trimLeft(byte[] bytes, Position pos) {
        if (bytes == null) {
            return;
        }
        int length = bytes.length;
        while (pos.start < length && bytes[pos.start] == 32) {
            ++pos.start;
        }
        pos.end = pos.start;
    }

    public static int trimLeft(byte[] bytes, int pos) {
        if (bytes == null) {
            return pos;
        }
        while (pos < bytes.length && bytes[pos] == 32) {
            ++pos;
        }
        return pos;
    }

    public static String trimRight(String str) {
        int length;
        int end;
        if (Strings.isEmpty(str)) {
            return EMPTY_STRING;
        }
        for (end = length = str.length(); end > 0 && str.charAt(end - 1) == ' ' && (end <= 1 || str.charAt(end - 2) != '\\'); --end) {
        }
        return end == length ? str : str.substring(0, end);
    }

    public static String trimRight(String str, int escapedSpace) {
        int length;
        int end;
        if (Strings.isEmpty(str)) {
            return EMPTY_STRING;
        }
        for (end = length = str.length(); end > 0 && str.charAt(end - 1) == ' ' && end > escapedSpace && (end <= 1 || str.charAt(end - 2) != '\\'); --end) {
        }
        return end == length ? str : str.substring(0, end);
    }

    public static int trimRight(char[] chars, int pos) {
        if (chars == null) {
            return pos;
        }
        while (pos >= 0 && chars[pos - 1] == ' ') {
            --pos;
        }
        return pos;
    }

    public static String trimRight(String string, Position pos) {
        if (string == null) {
            return EMPTY_STRING;
        }
        while (pos.end >= 0 && string.charAt(pos.end - 1) == ' ' && (pos.end <= 1 || string.charAt(pos.end - 2) != '\\')) {
            --pos.end;
        }
        return pos.end == string.length() ? string : string.substring(0, pos.end);
    }

    public static String trimRight(byte[] bytes, Position pos) {
        if (bytes == null) {
            return EMPTY_STRING;
        }
        while (pos.end >= 0 && bytes[pos.end - 1] == 32 && (pos.end <= 1 || bytes[pos.end - 2] != 92)) {
            --pos.end;
        }
        if (pos.end == bytes.length) {
            return Strings.utf8ToString(bytes);
        }
        return Strings.utf8ToString(bytes, pos.end);
    }

    public static int trimRight(byte[] bytes, int pos) {
        if (bytes == null) {
            return pos;
        }
        while (pos >= 0 && bytes[pos] == 32) {
            --pos;
        }
        return pos;
    }

    public static char charAt(String string, int index) {
        if (string == null) {
            return '\u0000';
        }
        int length = string.length();
        if (length == 0 || index < 0 || index >= length) {
            return '\u0000';
        }
        return string.charAt(index);
    }

    public static byte byteAt(byte[] bytes, int index) {
        if (bytes == null) {
            return 0;
        }
        int length = bytes.length;
        if (length == 0 || index < 0 || index >= length) {
            return 0;
        }
        return bytes[index];
    }

    public static char charAt(char[] chars, int index) {
        if (chars == null) {
            return '\u0000';
        }
        int length = chars.length;
        if (length == 0 || index < 0 || index >= length) {
            return '\u0000';
        }
        return chars[index];
    }

    public static String asciiBytesToString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return EMPTY_STRING;
        }
        char[] result = new char[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = (char)bytes[i];
        }
        return new String(result);
    }

    public static byte[] getBytesUtf8(String string) {
        if (string == null) {
            return EMPTY_BYTES;
        }
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] getBytesUtf8Ascii(String string) {
        if (string == null) {
            return EMPTY_BYTES;
        }
        try {
            byte[] bytes = new byte[string.length()];
            int pos = 0;
            for (int i = 0; i < string.length(); ++i) {
                bytes[pos++] = UTF8[string.charAt(i)];
            }
            return bytes;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return string.getBytes(StandardCharsets.UTF_8);
        }
    }

    public static String getDefaultCharsetName() {
        return Charset.defaultCharset().name();
    }

    public static boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static String listToString(List<?> list) {
        if (list == null || list.isEmpty()) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Object elem : list) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(elem);
        }
        return sb.toString();
    }

    public static String setToString(Set<?> set) {
        if (set == null || set.isEmpty()) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Object elem : set) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(elem);
        }
        return sb.toString();
    }

    public static String listToString(List<?> list, String tabs) {
        if (list == null || list.isEmpty()) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder();
        for (Object elem : list) {
            sb.append(tabs);
            sb.append(elem);
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String mapToString(Map<?, ?> map) {
        if (map == null || map.size() == 0) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(entry.getKey());
            sb.append(" = '").append(entry.getValue()).append("'");
        }
        return sb.toString();
    }

    public static String mapToString(Map<?, ?> map, String tabs) {
        if (map == null || map.size() == 0) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            sb.append(tabs);
            sb.append(entry.getKey());
            sb.append(" = '").append(entry.getValue().toString()).append("'\n");
        }
        return sb.toString();
    }

    @Deprecated
    public static String toLowerCase(String value) {
        if (null == value || value.length() == 0) {
            return EMPTY_STRING;
        }
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = TO_LOWER_CASE[chars[i]];
        }
        return new String(chars);
    }

    public static String toLowerCaseAscii(String value) {
        if (null == value || value.length() == 0) {
            return EMPTY_STRING;
        }
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = TO_LOWER_CASE[chars[i]];
        }
        return new String(chars);
    }

    public static String toLowerCase(byte[] value) {
        if (null == value || value.length == 0) {
            return EMPTY_STRING;
        }
        for (int i = 0; i < value.length; ++i) {
            value[i] = TO_LOWER_CASE_BYTE[value[i]];
        }
        return Strings.utf8ToString(value);
    }

    @Deprecated
    public static String toUpperCase(String value) {
        if (null == value || value.length() == 0) {
            return EMPTY_STRING;
        }
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = UPPER_CASE[chars[i]];
        }
        return new String(chars);
    }

    public static String toUpperCaseAscii(String value) {
        if (null == value || value.length() == 0) {
            return EMPTY_STRING;
        }
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = UPPER_CASE[chars[i]];
        }
        return new String(chars);
    }

    public static String upperCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase(Locale.ROOT);
    }

    public static String lowerCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase(Locale.ROOT);
    }

    public static String lowerCaseAscii(String str) {
        if (str == null) {
            return null;
        }
        char[] chars = str.toCharArray();
        int pos = 0;
        for (char c : chars) {
            chars[pos++] = TO_LOWER_CASE[c];
        }
        return new String(chars);
    }

    public static boolean isPrintableString(String str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        for (char c : str.toCharArray()) {
            if (c <= '\u007f' && IS_PRINTABLE_CHAR[c]) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isIA5String(String str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        for (char c : str.toCharArray()) {
            if (c >= '\u0000' && c <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public static boolean isValidUuid(String uuid) {
        if (uuid.length() < 36) {
            return false;
        }
        if (Chars.isHex(uuid.charAt(0)) && Chars.isHex(uuid.charAt(1)) && Chars.isHex(uuid.charAt(2)) && Chars.isHex(uuid.charAt(3)) && Chars.isHex(uuid.charAt(4)) && Chars.isHex(uuid.charAt(5)) && Chars.isHex(uuid.charAt(6)) && Chars.isHex(uuid.charAt(7)) && uuid.charAt(8) == '-' && Chars.isHex(uuid.charAt(9)) && Chars.isHex(uuid.charAt(10)) && Chars.isHex(uuid.charAt(11)) && Chars.isHex(uuid.charAt(12)) && uuid.charAt(13) == '-' && Chars.isHex(uuid.charAt(14)) && Chars.isHex(uuid.charAt(15)) && Chars.isHex(uuid.charAt(16)) && Chars.isHex(uuid.charAt(17)) && uuid.charAt(18) == '-' && Chars.isHex(uuid.charAt(19)) && Chars.isHex(uuid.charAt(20)) && Chars.isHex(uuid.charAt(21)) && Chars.isHex(uuid.charAt(22)) && uuid.charAt(23) == '-' && Chars.isHex(uuid.charAt(24)) && Chars.isHex(uuid.charAt(25)) && Chars.isHex(uuid.charAt(26)) && Chars.isHex(uuid.charAt(27)) && Chars.isHex(uuid.charAt(28)) && Chars.isHex(uuid.charAt(29)) && Chars.isHex(uuid.charAt(30)) && Chars.isHex(uuid.charAt(31)) && Chars.isHex(uuid.charAt(32)) && Chars.isHex(uuid.charAt(33)) && Chars.isHex(uuid.charAt(34)) && Chars.isHex(uuid.charAt(35))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_17007_SYNTAX_VALID, uuid));
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_17008_SYNTAX_INVALID, uuid));
        }
        return false;
    }

    public static String uuidToString(byte[] bytes) {
        if (bytes == null || bytes.length != 16) {
            return "Invalid UUID";
        }
        char[] hex = Hex.encodeHex(bytes);
        StringBuilder sb = new StringBuilder();
        sb.append(hex, 0, 8);
        sb.append('-');
        sb.append(hex, 8, 4);
        sb.append('-');
        sb.append(hex, 12, 4);
        sb.append('-');
        sb.append(hex, 16, 4);
        sb.append('-');
        sb.append(hex, 20, 12);
        return Strings.toLowerCaseAscii(sb.toString());
    }

    public static byte[] uuidToBytes(String string) {
        if (!Strings.isValidUuid(string)) {
            return null;
        }
        char[] chars = string.toCharArray();
        byte[] bytes = new byte[]{Hex.getHexValue(chars[0], chars[1]), Hex.getHexValue(chars[2], chars[3]), Hex.getHexValue(chars[4], chars[5]), Hex.getHexValue(chars[6], chars[7]), Hex.getHexValue(chars[9], chars[10]), Hex.getHexValue(chars[11], chars[12]), Hex.getHexValue(chars[14], chars[15]), Hex.getHexValue(chars[16], chars[17]), Hex.getHexValue(chars[19], chars[20]), Hex.getHexValue(chars[21], chars[22]), Hex.getHexValue(chars[24], chars[25]), Hex.getHexValue(chars[26], chars[27]), Hex.getHexValue(chars[28], chars[29]), Hex.getHexValue(chars[30], chars[31]), Hex.getHexValue(chars[32], chars[33]), Hex.getHexValue(chars[34], chars[35])};
        return bytes;
    }

    public static byte[] copy(byte[] value) {
        if (Strings.isEmpty(value)) {
            return EMPTY_BYTES;
        }
        byte[] copy = new byte[value.length];
        System.arraycopy(value, 0, copy, 0, value.length);
        return copy;
    }

    public static String getString(byte[] data, int offset, int length, String charset) {
        if (data == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_17028_PARAMETER_CANT_BE_NULL, new Object[0]));
        }
        if (charset == null || charset.length() == 0) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_17029_CHARSET_CANT_BE_NULL, new Object[0]));
        }
        try {
            return new String(data, offset, length, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(data, offset, length, Charset.defaultCharset());
        }
    }

    public static String getString(byte[] data, int offset, int length, Charset charset) {
        if (data == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_17028_PARAMETER_CANT_BE_NULL, new Object[0]));
        }
        if (charset == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_17029_CHARSET_CANT_BE_NULL, new Object[0]));
        }
        return new String(data, offset, length, charset);
    }

    public static String getString(byte[] data, String charset) {
        return Strings.getString(data, 0, data.length, charset);
    }

    public static String getString(byte[] data, Charset charset) {
        return Strings.getString(data, 0, data.length, charset);
    }

    public static String getUUID(long value) {
        return new UUID(0L, value).toString();
    }

    public static int parseInt(String value) {
        long res = 0L;
        for (char c : value.toCharArray()) {
            if (c >= '0' && c <= '9') {
                if ((res = res * 10L + (long)(c - 48)) <= Integer.MAX_VALUE) continue;
                throw new NumberFormatException(I18n.err(I18n.ERR_17002_INTEGER_TOO_BIG, value));
            }
            throw new NumberFormatException(I18n.err(I18n.ERR_17003_INTEGER_INVALID, value));
        }
        return (int)res;
    }

    public static int compare(byte[] b1, byte[] b2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_17006_COMPARING_OBJECTSTRING, Strings.dumpBytes(b1), Strings.dumpBytes(b2)));
        }
        if (b1 == null) {
            return b2 == null ? 0 : -1;
        }
        if (b2 == null) {
            return 1;
        }
        if (b1.length == b2.length) {
            for (int i = 0; i < b1.length; ++i) {
                if (b1[i] > b2[i]) {
                    return 1;
                }
                if (b1[i] >= b2[i]) continue;
                return -1;
            }
            return 0;
        }
        int minLength = Math.min(b1.length, b2.length);
        for (int i = 0; i < minLength; ++i) {
            if (b1[i] > b2[i]) {
                return 1;
            }
            if (b1[i] >= b2[i]) continue;
            return -1;
        }
        if (b1.length == minLength) {
            return -1;
        }
        if (b2.length == minLength) {
            return 1;
        }
        return 0;
    }
}

