/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.util.IOUtils;

public final class FileUtils {
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final char SYSTEM_SEPARATOR = File.separatorChar;
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    private static final long FILE_COPY_BUFFER_SIZE = 0x1E00000L;

    private FileUtils() {
    }

    public static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        if (!FileUtils.isSymlink(directory)) {
            FileUtils.cleanDirectory(directory);
        }
        if (!directory.delete()) {
            throw new IOException(I18n.err(I18n.ERR_17004_UNABLE_DELETE_DIR, directory));
        }
    }

    public static boolean isSymlink(File file) throws IOException {
        File fileInCanonicalDir;
        if (file == null) {
            throw new NullPointerException(I18n.err(I18n.ERR_17005_FILE_MUST_NOT_BE_NULL, new Object[0]));
        }
        if (SYSTEM_SEPARATOR == '\\') {
            return false;
        }
        if (file.getParent() == null) {
            fileInCanonicalDir = file;
        } else {
            File canonicalDir = file.getParentFile().getCanonicalFile();
            fileInCanonicalDir = new File(canonicalDir, file.getName());
        }
        return !fileInCanonicalDir.getCanonicalFile().equals(fileInCanonicalDir.getAbsoluteFile());
    }

    public static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_17006_DOES_NOT_EXIST, directory));
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_17007_IS_NOT_DIRECTORY, directory));
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException(I18n.err(I18n.ERR_17008_FAIL_LIST_DIR, directory));
        }
        IOException exception = null;
        for (File file : files) {
            try {
                FileUtils.forceDelete(file);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    public static void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtils.deleteDirectory(file);
        } else {
            boolean filePresent = file.exists();
            if (!file.delete()) {
                if (!filePresent) {
                    throw new FileNotFoundException(I18n.err(I18n.ERR_17009_FILE_DOES_NOT_EXIST, file));
                }
                throw new IOException(I18n.err(I18n.ERR_17010_UNABLE_DELETE_FILE, file));
            }
        }
    }

    public static String getTempDirectoryPath() {
        return System.getProperty("java.io.tmpdir");
    }

    @Deprecated
    public static String readFileToString(File file) throws IOException {
        return FileUtils.readFileToString(file, Charset.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(File file, Charset encoding) throws IOException {
        InputStream in = null;
        try {
            in = FileUtils.openInputStream(file);
            String string = IOUtils.toString(in, IOUtils.toCharset(encoding));
            return string;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(File file, String encoding) throws IOException {
        InputStream in = null;
        try {
            in = FileUtils.openInputStream(file);
            String string = IOUtils.toString(in, IOUtils.toCharset(encoding));
            return string;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public static InputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException(I18n.err(I18n.ERR_17011_FILE_IS_DIR, file));
            }
            if (!file.canRead()) {
                throw new IOException(I18n.err(I18n.ERR_17012_CANNOT_READ_FILE, file));
            }
        } else {
            throw new FileNotFoundException(I18n.err(I18n.ERR_17013_FILE_DOES_NOT_EXIST, file));
        }
        return Files.newInputStream(Paths.get(file.getPath(), new String[0]), new OpenOption[0]);
    }

    @Deprecated
    public static void writeStringToFile(File file, String data) throws IOException {
        FileUtils.writeStringToFile(file, data, Charset.defaultCharset(), false);
    }

    public static void writeStringToFile(File file, String data, String encoding) throws IOException {
        FileUtils.writeStringToFile(file, data, IOUtils.toCharset(encoding), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(File file, String data, Charset encoding, boolean append) throws IOException {
        OutputStream out = null;
        try {
            out = FileUtils.openOutputStream(file, append);
            IOUtils.write(data, out, encoding);
            out.close();
        }
        finally {
            IOUtils.closeQuietly((Closeable)out);
        }
    }

    public static OutputStream openOutputStream(File file, boolean append) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException(I18n.err(I18n.ERR_17011_FILE_IS_DIR, file));
            }
            if (!file.canWrite()) {
                throw new IOException(I18n.err(I18n.ERR_17014_CANNOT_WRITE_FILE, file));
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.mkdirs() && !parent.isDirectory()) {
                throw new IOException(I18n.err(I18n.ERR_17015_CANNOT_CREATE_DIR, parent));
            }
        }
        if (append) {
            return Files.newOutputStream(Paths.get(file.getPath(), new String[0]), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        return Files.newOutputStream(Paths.get(file.getPath(), new String[0]), new OpenOption[0]);
    }

    public static File getTempDirectory() {
        return new File(FileUtils.getTempDirectoryPath());
    }

    public static boolean deleteQuietly(File file) {
        if (file == null) {
            return false;
        }
        try {
            if (file.isDirectory()) {
                FileUtils.cleanDirectory(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return file.delete();
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static void writeByteArrayToFile(File file, byte[] data) throws IOException {
        FileUtils.writeByteArrayToFile(file, data, false);
    }

    public static void writeByteArrayToFile(File file, byte[] data, boolean append) throws IOException {
        FileUtils.writeByteArrayToFile(file, data, 0, data.length, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeByteArrayToFile(File file, byte[] data, int off, int len, boolean append) throws IOException {
        OutputStream out = null;
        try {
            out = FileUtils.openOutputStream(file, append);
            out.write(data, off, len);
            out.close();
        }
        finally {
            IOUtils.closeQuietly((Closeable)out);
        }
    }

    public static byte[] readFileToByteArray(File file) throws IOException {
        InputStream in = null;
        try {
            in = FileUtils.openInputStream(file);
            byte[] byArray = IOUtils.toByteArray(in, file.length());
            return byArray;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public static OutputStream openOutputStream(File file) throws IOException {
        return FileUtils.openOutputStream(file, false);
    }

    @Deprecated
    public static List<String> readLines(File file) throws IOException {
        return FileUtils.readLines(file, Charset.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(File file, Charset encoding) throws IOException {
        InputStream in = null;
        try {
            in = FileUtils.openInputStream(file);
            List<String> list = IOUtils.readLines(in, IOUtils.toCharset(encoding));
            return list;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }
}

