/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.normalizers;

import org.apache.hadoop.shaded.org.apache.directory.api.asn1.util.Oid;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.PrepareString;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;

public class ObjectIdentifierNormalizer
extends Normalizer {
    private transient SchemaManager schemaManager;

    public ObjectIdentifierNormalizer() {
        super("2.5.13.0");
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    @Override
    public String normalize(String value) throws LdapException {
        if (Strings.isEmpty(value)) {
            return "";
        }
        String trimmedValue = value.trim();
        if (Strings.isEmpty(trimmedValue)) {
            return "";
        }
        String oid = this.schemaManager.getRegistries().getOid(trimmedValue);
        if (oid == null) {
            if (Oid.isOid(trimmedValue)) {
                oid = trimmedValue;
            } else {
                for (int i = 0; i < trimmedValue.length(); ++i) {
                    char c = trimmedValue.charAt(i);
                    if (!(i == 0 ? !Character.isLetter(c) : !Character.isDigit(c) && !Character.isLetter(c) && c != '-' && c != '_')) continue;
                    throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_13724_INVALID_VALUE, value));
                }
                oid = trimmedValue;
            }
        }
        return oid;
    }

    @Override
    public String normalize(String value, PrepareString.AssertionType assertionType) throws LdapException {
        return this.normalize(value);
    }
}

