/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.normalizers;

import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.entry.Value;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.PrepareString;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.PreparedNormalizer;

public class NumericNormalizer
extends Normalizer
implements PreparedNormalizer {
    public NumericNormalizer() {
        super("2.5.13.8");
    }

    public Value normalize(Value value) throws LdapException {
        String normalized = this.normalize(value.getString());
        return new Value(normalized);
    }

    @Override
    public String normalize(String value) throws LdapException {
        return this.normalize(value, PrepareString.AssertionType.ATTRIBUTE_VALUE);
    }

    @Override
    public String normalize(String value, PrepareString.AssertionType assertionType) throws LdapException {
        if (value == null) {
            return null;
        }
        char[] chars = value.toCharArray();
        return PrepareString.insignificantNumericStringHandling(chars);
    }
}

