/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.normalizers;

import java.io.IOException;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.PrepareString;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.PreparedNormalizer;

public class DeepTrimToLowerNormalizer
extends Normalizer
implements PreparedNormalizer {
    public DeepTrimToLowerNormalizer(String oid) {
        super(oid);
    }

    public DeepTrimToLowerNormalizer() {
    }

    @Override
    public String normalize(String value) throws LdapException {
        return this.normalize(value, PrepareString.AssertionType.ATTRIBUTE_VALUE);
    }

    @Override
    public String normalize(String value, PrepareString.AssertionType assertionType) throws LdapException {
        if (value == null) {
            return null;
        }
        String normValue = null;
        try {
            String mapped = PrepareString.mapIgnoreCase(value);
            String normalized = PrepareString.normalize(mapped);
            char[] chars = normalized.toCharArray();
            PrepareString.checkProhibited(chars);
            switch (assertionType) {
                case ATTRIBUTE_VALUE: {
                    normValue = PrepareString.insignificantSpacesStringValue(chars);
                    break;
                }
                case SUBSTRING_INITIAL: {
                    normValue = PrepareString.insignificantSpacesStringInitial(chars);
                    break;
                }
                case SUBSTRING_ANY: {
                    normValue = PrepareString.insignificantSpacesStringAny(chars);
                    break;
                }
                case SUBSTRING_FINAL: {
                    normValue = PrepareString.insignificantSpacesStringFinal(chars);
                    break;
                }
            }
            return normValue;
        }
        catch (IOException ioe) {
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_13724_INVALID_VALUE, value), ioe);
        }
    }
}

