/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema;

import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.SchemaObjectRenderer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.SchemaObjectType;

public class MatchingRule
extends AbstractSchemaObject {
    public static final long serialVersionUID = 1L;
    protected LdapComparator<? super Object> ldapComparator;
    protected Normalizer normalizer;
    protected LdapSyntax ldapSyntax;
    protected String ldapSyntaxOid;

    public MatchingRule(String oid) {
        super(SchemaObjectType.MATCHING_RULE, oid);
    }

    public LdapSyntax getSyntax() {
        return this.ldapSyntax;
    }

    public void setSyntax(LdapSyntax ldapSyntax) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.ldapSyntax = ldapSyntax;
        this.ldapSyntaxOid = ldapSyntax.getOid();
    }

    public String getSyntaxOid() {
        return this.ldapSyntaxOid;
    }

    public void setSyntaxOid(String oid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.ldapSyntaxOid = oid;
    }

    public LdapComparator<? super Object> getLdapComparator() {
        return this.ldapComparator;
    }

    public void setLdapComparator(LdapComparator<?> ldapComparator) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.ldapComparator = ldapComparator;
    }

    public Normalizer getNormalizer() {
        return this.normalizer;
    }

    public void setNormalizer(Normalizer normalizer) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.normalizer = normalizer;
    }

    public String toString() {
        return SchemaObjectRenderer.OPEN_LDAP_SCHEMA_RENDERER.render(this);
    }

    @Override
    public MatchingRule copy() {
        MatchingRule copy = new MatchingRule(this.oid);
        copy.copy(this);
        copy.ldapComparator = null;
        copy.ldapSyntax = null;
        copy.normalizer = null;
        copy.ldapSyntaxOid = this.ldapSyntaxOid;
        return copy;
    }

    @Override
    public int hashCode() {
        int hash = this.h;
        if (this.ldapComparator != null) {
            hash = hash * 37 + this.ldapComparator.hashCode();
        }
        if (this.ldapSyntax != null) {
            hash = hash * 37 + this.ldapSyntax.hashCode();
        }
        if (this.normalizer != null) {
            hash = hash * 37 + this.normalizer.hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof MatchingRule)) {
            return false;
        }
        MatchingRule that = (MatchingRule)o;
        if (this.ldapComparator != null ? !this.ldapComparator.equals(that.ldapComparator) : that.ldapComparator != null) {
            return false;
        }
        if (this.normalizer != null ? !this.normalizer.equals(that.normalizer) : that.normalizer != null) {
            return false;
        }
        if (!this.compareOid(this.ldapSyntaxOid, that.ldapSyntaxOid)) {
            return false;
        }
        return !(this.ldapSyntax != null ? !this.ldapSyntax.equals(that.ldapSyntax) : that.ldapSyntax != null);
    }

    @Override
    public void clear() {
        super.clear();
        this.ldapComparator = null;
        this.ldapSyntax = null;
        this.normalizer = null;
    }
}

