/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema;

import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.SchemaObjectRenderer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.SchemaObjectType;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.UsageEnum;

public class AttributeType
extends AbstractSchemaObject
implements Cloneable {
    public static final long serialVersionUID = 1L;
    protected String syntaxOid;
    protected LdapSyntax syntax;
    protected String equalityOid;
    protected MatchingRule equality;
    protected String substringOid;
    protected MatchingRule substring;
    protected String orderingOid;
    protected MatchingRule ordering;
    protected String superiorOid;
    protected AttributeType superior;
    protected boolean isSingleValued = false;
    protected boolean isCollective = false;
    protected boolean canUserModify = true;
    protected UsageEnum usage = UsageEnum.USER_APPLICATIONS;
    protected long syntaxLength = 0L;
    private boolean isRelaxed = false;

    public AttributeType(String oid) {
        super(SchemaObjectType.ATTRIBUTE_TYPE, oid);
    }

    public boolean isSingleValued() {
        return this.isSingleValued;
    }

    public void setSingleValued(boolean singleValued) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.isSingleValued = singleValued;
    }

    public boolean isUserModifiable() {
        return this.canUserModify;
    }

    public void setUserModifiable(boolean userModifiable) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.canUserModify = userModifiable;
    }

    public boolean isCollective() {
        return this.isCollective;
    }

    public void setCollective(boolean collective) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.isCollective = collective;
    }

    public boolean isRelaxed() {
        return this.isRelaxed;
    }

    public void setRelaxed(boolean isRelaxed) {
        this.isRelaxed = isRelaxed;
    }

    public UsageEnum getUsage() {
        return this.usage;
    }

    public void setUsage(UsageEnum usage) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.usage = usage;
    }

    public long getSyntaxLength() {
        return this.syntaxLength;
    }

    public void setSyntaxLength(long length) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.syntaxLength = length;
    }

    public AttributeType getSuperior() {
        return this.superior;
    }

    public String getSuperiorOid() {
        return this.superiorOid;
    }

    public void setSuperior(AttributeType superior) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.superior = superior;
        this.superiorOid = superior.getOid();
    }

    public void setSuperior(String newSuperiorOid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.superiorOid = newSuperiorOid;
    }

    public void setSuperiorOid(String superiorOid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.superiorOid = superiorOid;
    }

    public String getSuperiorName() {
        if (this.superior != null) {
            return this.superior.getName();
        }
        return this.superiorOid;
    }

    public LdapSyntax getSyntax() {
        return this.syntax;
    }

    public void setSyntax(LdapSyntax syntax) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.syntax = syntax;
        this.syntaxOid = syntax.getOid();
    }

    public String getSyntaxName() {
        if (this.syntax != null) {
            return this.syntax.getName();
        }
        return this.syntaxOid;
    }

    public String getSyntaxOid() {
        return this.syntaxOid;
    }

    public void setSyntaxOid(String syntaxOid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.syntaxOid = syntaxOid;
    }

    public MatchingRule getEquality() {
        return this.equality;
    }

    public void setEquality(MatchingRule equality) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.equality = equality;
        this.equalityOid = equality.getOid();
    }

    public String getEqualityOid() {
        return this.equalityOid;
    }

    public void setEqualityOid(String equalityOid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.equalityOid = equalityOid;
    }

    public String getEqualityName() {
        if (this.equality != null) {
            return this.equality.getName();
        }
        return this.equalityOid;
    }

    public MatchingRule getOrdering() {
        return this.ordering;
    }

    public void setOrdering(MatchingRule ordering) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.ordering = ordering;
        this.orderingOid = ordering.getOid();
    }

    public String getOrderingName() {
        if (this.ordering != null) {
            return this.ordering.getName();
        }
        return this.orderingOid;
    }

    public String getOrderingOid() {
        return this.orderingOid;
    }

    public void setOrderingOid(String orderingOid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.orderingOid = orderingOid;
    }

    public MatchingRule getSubstring() {
        return this.substring;
    }

    public void setSubstring(MatchingRule substring) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.substring = substring;
        this.substringOid = substring.getOid();
    }

    public String getSubstringName() {
        if (this.substring != null) {
            return this.substring.getName();
        }
        return this.substringOid;
    }

    public String getSubstringOid() {
        return this.substringOid;
    }

    public void setSubstringOid(String substrOid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.substringOid = substrOid;
    }

    public boolean isUser() {
        return this.usage == UsageEnum.USER_APPLICATIONS;
    }

    public boolean isOperational() {
        return this.usage != UsageEnum.USER_APPLICATIONS;
    }

    public boolean isAncestorOf(AttributeType descendant) {
        if (descendant == null || this.equals(descendant)) {
            return false;
        }
        return this.isAncestorOrEqual(this, descendant);
    }

    public boolean isHR() {
        return this.syntax != null && this.syntax.isHumanReadable();
    }

    public boolean isDescendantOf(AttributeType ancestor) {
        if (ancestor == null || this.equals(ancestor)) {
            return false;
        }
        return this.isAncestorOrEqual(ancestor, this);
    }

    private boolean isAncestorOrEqual(AttributeType ancestor, AttributeType descendant) {
        if (ancestor == null || descendant == null) {
            return false;
        }
        if (ancestor.equals(descendant)) {
            return true;
        }
        return this.isAncestorOrEqual(ancestor, descendant.getSuperior());
    }

    public String toString() {
        return SchemaObjectRenderer.OPEN_LDAP_SCHEMA_RENDERER.render(this);
    }

    @Override
    public AttributeType copy() {
        AttributeType copy = new AttributeType(this.oid);
        copy.copy(this);
        copy.canUserModify = this.canUserModify;
        copy.isCollective = this.isCollective;
        copy.isSingleValued = this.isSingleValued;
        copy.usage = this.usage;
        copy.equality = null;
        copy.equalityOid = this.equalityOid;
        copy.ordering = null;
        copy.orderingOid = this.orderingOid;
        copy.substring = null;
        copy.substringOid = this.substringOid;
        copy.superior = null;
        copy.superiorOid = this.superiorOid;
        copy.syntax = null;
        copy.syntaxOid = this.syntaxOid;
        copy.syntaxLength = this.syntaxLength;
        copy.setRelaxed(this.isRelaxed);
        return copy;
    }

    @Override
    public int hashCode() {
        int ath = super.hashCode();
        ath += ath * 17 + (this.canUserModify ? 1 : 0);
        ath += ath * 17 + (this.isCollective ? 1 : 0);
        ath += ath * 17 + (this.isSingleValued ? 1 : 0);
        if (this.syntax != null) {
            ath += ath * 17 + this.syntax.hashCode();
        }
        if (this.equality != null) {
            ath += ath * 17 + this.equality.hashCode();
        }
        if (this.substring != null) {
            ath += ath * 17 + this.substring.hashCode();
        }
        if (this.superior != null) {
            ath += ath * 17 + this.superior.hashCode();
        }
        if (this.ordering != null) {
            ath += ath * 17 + this.ordering.hashCode();
        }
        ath += ath * 17 + this.usage.getValue();
        return ath;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof AttributeType)) {
            return false;
        }
        AttributeType that = (AttributeType)o;
        if (this.isCollective != that.isCollective) {
            return false;
        }
        if (this.isSingleValued != that.isSingleValued) {
            return false;
        }
        if (this.canUserModify != that.canUserModify) {
            return false;
        }
        if (this.usage != that.usage) {
            return false;
        }
        if (!this.compareOid(this.equalityOid, that.equalityOid)) {
            return false;
        }
        if (this.equality != null ? !this.equality.equals(that.equality) : that.equality != null) {
            return false;
        }
        if (!this.compareOid(this.orderingOid, that.orderingOid)) {
            return false;
        }
        if (this.ordering != null ? !this.ordering.equals(that.ordering) : that.ordering != null) {
            return false;
        }
        if (!this.compareOid(this.substringOid, that.substringOid)) {
            return false;
        }
        if (this.substring != null ? !this.substring.equals(that.substring) : that.substring != null) {
            return false;
        }
        if (!this.compareOid(this.superiorOid, that.superiorOid)) {
            return false;
        }
        if (this.superior != null ? !this.superior.equals(that.superior) : that.superior != null) {
            return false;
        }
        if (!this.compareOid(this.syntaxOid, that.syntaxOid)) {
            return false;
        }
        if (this.syntaxLength != that.syntaxLength) {
            return false;
        }
        if (this.syntax == null) {
            return that.syntax == null;
        }
        if (this.syntax.equals(that.syntax)) {
            return this.syntaxLength == that.syntaxLength;
        }
        return false;
    }

    @Override
    public void clear() {
        super.clear();
        this.equality = null;
        this.ordering = null;
        this.substring = null;
        this.superior = null;
        this.syntax = null;
    }
}

