/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message;

import java.util.Arrays;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.AbstractRequest;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.Control;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.OpaqueExtendedResponse;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;

public class OpaqueExtendedRequest
extends AbstractRequest
implements ExtendedRequest {
    static final long serialVersionUID = 7916990159044177480L;
    private String oid;
    private byte[] requestValue;
    protected ExtendedResponse response;

    public OpaqueExtendedRequest() {
        super(-1, MessageTypeEnum.EXTENDED_REQUEST, true);
    }

    public OpaqueExtendedRequest(String requestName) {
        super(-1, MessageTypeEnum.EXTENDED_REQUEST, true);
        this.oid = requestName;
    }

    public OpaqueExtendedRequest(byte[] requestValue) {
        super(-1, MessageTypeEnum.EXTENDED_REQUEST, true);
        this.requestValue = requestValue;
    }

    public OpaqueExtendedRequest(String requestName, byte[] requestValue) {
        super(-1, MessageTypeEnum.EXTENDED_REQUEST, true);
        this.oid = requestName;
        this.requestValue = requestValue;
    }

    @Override
    public String getRequestName() {
        return this.oid;
    }

    @Override
    public ExtendedRequest setRequestName(String newOid) {
        this.oid = newOid;
        return this;
    }

    @Override
    public ExtendedRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    @Override
    public ExtendedRequest addControl(Control control) {
        return (ExtendedRequest)super.addControl(control);
    }

    @Override
    public ExtendedRequest addAllControls(Control[] controls) {
        return (ExtendedRequest)super.addAllControls(controls);
    }

    @Override
    public ExtendedRequest removeControl(Control control) {
        return (ExtendedRequest)super.removeControl(control);
    }

    @Override
    public MessageTypeEnum getResponseType() {
        return MessageTypeEnum.EXTENDED_RESPONSE;
    }

    public ExtendedResponse getExtendedResponse() {
        if (this.response == null) {
            this.response = new OpaqueExtendedResponse(this.getMessageId());
        }
        return this.response;
    }

    @Override
    public ExtendedResponse getResultResponse() {
        return this.getExtendedResponse();
    }

    public byte[] getRequestValue() {
        return this.requestValue;
    }

    public void setRequestValue(byte[] requestValue) {
        this.requestValue = requestValue;
    }

    @Override
    public int hashCode() {
        int hash = 37;
        hash = hash * 17 + super.hashCode();
        if (this.oid != null) {
            hash = hash * 17 + this.oid.hashCode();
        }
        if (this.requestValue != null) {
            for (byte b : this.requestValue) {
                hash = hash * 17 + b;
            }
        }
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OpaqueExtendedRequest)) {
            return false;
        }
        OpaqueExtendedRequest extendedRequest = (OpaqueExtendedRequest)obj;
        if (this.oid != null && !this.oid.equals(extendedRequest.oid) || this.oid == null && extendedRequest.oid != null) {
            return false;
        }
        return Arrays.equals(this.requestValue, extendedRequest.requestValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Extended request\n");
        sb.append("        Request name :  '").append(this.oid).append("'\n");
        sb.append("        Request value : '").append(Strings.dumpBytes(this.requestValue)).append("'\n");
        sb.append(super.toString());
        return super.toString(sb.toString());
    }
}

