/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.intermediate.syncrepl_impl;

import java.nio.ByteBuffer;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.DecoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.IntermediateOperationFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.intermediate.syncrepl.SyncInfoValue;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.intermediate.syncrepl.SyncInfoValueImpl;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.intermediate.syncrepl_impl.SyncInfoValueContainer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.intermediate.syncrepl_impl.SyncInfoValueTags;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.IntermediateResponse;

public class SyncInfoValueFactory
implements IntermediateOperationFactory {
    @Override
    public String getOid() {
        return "1.3.6.1.4.1.4203.1.9.1.4";
    }

    @Override
    public SyncInfoValue newResponse() {
        return new SyncInfoValueImpl();
    }

    @Override
    public SyncInfoValue newResponse(byte[] responseValue) {
        SyncInfoValueImpl syncInfoValue = new SyncInfoValueImpl();
        try {
            this.decodeValue(syncInfoValue, responseValue);
        }
        catch (DecoderException decoderException) {
            // empty catch block
        }
        return syncInfoValue;
    }

    @Override
    public void encodeValue(Asn1Buffer buffer, IntermediateResponse intermediateResponse) {
        int start = buffer.getPos();
        SyncInfoValue syncInfoValue = (SyncInfoValue)intermediateResponse;
        switch (syncInfoValue.getSyncInfoValueType()) {
            case NEW_COOKIE: {
                BerValue.encodeOctetString(buffer, (byte)SyncInfoValueTags.NEW_COOKIE_TAG.getValue(), syncInfoValue.getCookie());
                break;
            }
            case REFRESH_DELETE: {
                if (!syncInfoValue.isRefreshDone()) {
                    BerValue.encodeBoolean(buffer, false);
                }
                if (syncInfoValue.getCookie() != null) {
                    BerValue.encodeOctetString(buffer, syncInfoValue.getCookie());
                }
                BerValue.encodeSequence(buffer, (byte)SyncInfoValueTags.REFRESH_DELETE_TAG.getValue(), start);
                break;
            }
            case REFRESH_PRESENT: {
                if (!syncInfoValue.isRefreshDone()) {
                    BerValue.encodeBoolean(buffer, false);
                }
                if (syncInfoValue.getCookie() != null) {
                    BerValue.encodeOctetString(buffer, syncInfoValue.getCookie());
                }
                BerValue.encodeSequence(buffer, (byte)SyncInfoValueTags.REFRESH_PRESENT_TAG.getValue(), start);
                break;
            }
            case SYNC_ID_SET: {
                if (!syncInfoValue.getSyncUUIDs().isEmpty()) {
                    for (int i = syncInfoValue.getSyncUUIDs().size(); i > 0; --i) {
                        BerValue.encodeOctetString(buffer, syncInfoValue.getSyncUUIDs().get(i - 1));
                    }
                }
                BerValue.encodeSet(buffer, start);
                if (syncInfoValue.isRefreshDeletes()) {
                    BerValue.encodeBoolean(buffer, true);
                }
                if (syncInfoValue.getCookie() != null) {
                    BerValue.encodeOctetString(buffer, syncInfoValue.getCookie());
                }
                BerValue.encodeSequence(buffer, (byte)SyncInfoValueTags.SYNC_ID_SET_TAG.getValue(), start);
                break;
            }
        }
    }

    @Override
    public void decodeValue(IntermediateResponse intermediateResponse, byte[] responseValue) throws DecoderException {
        ByteBuffer buffer = ByteBuffer.wrap(responseValue);
        SyncInfoValueContainer container = new SyncInfoValueContainer((SyncInfoValue)intermediateResponse);
        Asn1Decoder.decode(buffer, container);
    }
}

