/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.extended.ads_impl.certGeneration;

import org.apache.hadoop.shaded.org.apache.directory.api.asn1.DecoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.extended.ads_impl.certGeneration.CertGenerationRequestContainer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.extended.ads_impl.certGeneration.CertGenerationRequestStatesEnum;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.name.Dn;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertGenerationRequestGrammar
extends AbstractGrammar<CertGenerationRequestContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(CertGenerationRequestGrammar.class);
    private static Grammar<CertGenerationRequestContainer> instance = new CertGenerationRequestGrammar();

    public CertGenerationRequestGrammar() {
        this.setName(CertGenerationRequestGrammar.class.getName());
        this.transitions = new GrammarTransition[CertGenerationRequestStatesEnum.LAST_CERT_GENERATION_STATE.ordinal()][256];
        this.transitions[CertGenerationRequestStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition(CertGenerationRequestStatesEnum.START_STATE, CertGenerationRequestStatesEnum.CERT_GENERATION_REQUEST_SEQUENCE_STATE, UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[CertGenerationRequestStatesEnum.CERT_GENERATION_REQUEST_SEQUENCE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<CertGenerationRequestContainer>(CertGenerationRequestStatesEnum.CERT_GENERATION_REQUEST_SEQUENCE_STATE, CertGenerationRequestStatesEnum.TARGETDN_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<CertGenerationRequestContainer>("Set Cert Generation target Dn value"){

            @Override
            public void action(CertGenerationRequestContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                String targetDN = Strings.utf8ToString(value.getData());
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_08215_TARGET_DN, targetDN));
                }
                if (targetDN != null && targetDN.trim().length() > 0) {
                    if (!Dn.isValid(targetDN)) {
                        String msg = I18n.err(I18n.ERR_08201_INVALID_TARGET_DN, targetDN);
                        LOG.error(msg);
                        throw new DecoderException(msg);
                    }
                } else {
                    String msg = I18n.err(I18n.ERR_08202_NULL_TARGET_DN_DECODING_FAILED, Strings.dumpBytes(value.getData()));
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                container.getCertGenerationRequest().setTargetDN(targetDN);
            }
        });
        this.transitions[CertGenerationRequestStatesEnum.TARGETDN_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<CertGenerationRequestContainer>(CertGenerationRequestStatesEnum.TARGETDN_STATE, CertGenerationRequestStatesEnum.ISSUER_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<CertGenerationRequestContainer>("Set Cert Generation issuer Dn value"){

            @Override
            public void action(CertGenerationRequestContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                String issuerDN = Strings.utf8ToString(value.getData());
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_08207_ISSUER_DN, issuerDN));
                }
                if (issuerDN != null && issuerDN.trim().length() > 0) {
                    if (!Dn.isValid(issuerDN)) {
                        String msg = I18n.err(I18n.ERR_08203_INVALID_ISSUER_DN, issuerDN);
                        LOG.error(msg);
                        throw new DecoderException(msg);
                    }
                    container.getCertGenerationRequest().setIssuerDN(issuerDN);
                }
            }
        });
        this.transitions[CertGenerationRequestStatesEnum.ISSUER_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<CertGenerationRequestContainer>(CertGenerationRequestStatesEnum.ISSUER_STATE, CertGenerationRequestStatesEnum.SUBJECT_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<CertGenerationRequestContainer>("Set Cert Generation subject Dn value"){

            @Override
            public void action(CertGenerationRequestContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                String subjectDN = Strings.utf8ToString(value.getData());
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_08219_SUBJECT_DN, subjectDN));
                }
                if (subjectDN != null && subjectDN.trim().length() > 0) {
                    if (!Dn.isValid(subjectDN)) {
                        String msg = I18n.err(I18n.ERR_08204_INVALID_SUBJECT_DN, subjectDN);
                        LOG.error(msg);
                        throw new DecoderException(msg);
                    }
                } else {
                    String msg = I18n.err(I18n.ERR_08202_NULL_TARGET_DN_DECODING_FAILED, Strings.dumpBytes(value.getData()));
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                container.getCertGenerationRequest().setSubjectDN(subjectDN);
            }
        });
        this.transitions[CertGenerationRequestStatesEnum.SUBJECT_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<CertGenerationRequestContainer>(CertGenerationRequestStatesEnum.SUBJECT_STATE, CertGenerationRequestStatesEnum.KEY_ALGORITHM_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<CertGenerationRequestContainer>("Set Cert Generation key algorithm value"){

            @Override
            public void action(CertGenerationRequestContainer container) {
                BerValue value = container.getCurrentTLV().getValue();
                String keyAlgorithm = Strings.utf8ToString(value.getData());
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_08218_KEY_ALGORITHM, keyAlgorithm));
                }
                if (keyAlgorithm != null && keyAlgorithm.trim().length() > 0) {
                    container.getCertGenerationRequest().setKeyAlgorithm(keyAlgorithm);
                }
                container.setGrammarEndAllowed(true);
            }
        });
    }

    public static Grammar<CertGenerationRequestContainer> getInstance() {
        return instance;
    }
}

