/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.controls.syncrepl_impl;

import org.apache.hadoop.shaded.org.apache.directory.api.asn1.DecoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.AbstractControlFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.controls.syncrepl.syncRequest.SyncRequestValue;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.controls.syncrepl.syncRequest.SyncRequestValueImpl;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncRequestValueContainer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.Control;

public class SyncRequestValueFactory
extends AbstractControlFactory<SyncRequestValue> {
    public SyncRequestValueFactory(LdapApiService codec) {
        super(codec, "1.3.6.1.4.1.4203.1.9.1.1");
    }

    @Override
    public SyncRequestValue newControl() {
        return new SyncRequestValueImpl();
    }

    @Override
    public void encodeValue(Asn1Buffer buffer, Control control) {
        int start = buffer.getPos();
        SyncRequestValue syncRequestValue = (SyncRequestValue)control;
        if (syncRequestValue.isReloadHint()) {
            BerValue.encodeBoolean(buffer, true);
        }
        if (syncRequestValue.getCookie() != null) {
            BerValue.encodeOctetString(buffer, syncRequestValue.getCookie());
        }
        BerValue.encodeEnumerated(buffer, syncRequestValue.getMode().getValue());
        BerValue.encodeSequence(buffer, start);
    }

    @Override
    public void decodeValue(Control control, byte[] controlBytes) throws DecoderException {
        this.decodeValue(new SyncRequestValueContainer(control), control, controlBytes);
    }
}

