/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api;

import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.BinaryAttributeDetector;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;

public class SchemaBinaryAttributeDetector
implements BinaryAttributeDetector {
    private SchemaManager schemaManager;

    protected SchemaBinaryAttributeDetector() {
    }

    public SchemaBinaryAttributeDetector(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    @Override
    public boolean isBinary(String attributeId) {
        String attrId = Strings.toLowerCaseAscii(attributeId);
        if (attrId.endsWith(";binary")) {
            return true;
        }
        if (this.schemaManager != null) {
            AttributeType attributeType = this.schemaManager.getAttributeType(attrId);
            if (attributeType == null) {
                return false;
            }
            LdapSyntax ldapSyntax = attributeType.getSyntax();
            return ldapSyntax != null && !ldapSyntax.isHumanReadable();
        }
        return false;
    }
}

