/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.actions.response.search.entry;

import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.SearchResultEntry;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreSearchResultAttributeValue
extends GrammarAction<LdapMessageContainer<SearchResultEntry>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSearchResultAttributeValue.class);

    public StoreSearchResultAttributeValue() {
        super("Stores AttributeValue");
    }

    @Override
    public void action(LdapMessageContainer<SearchResultEntry> container) {
        Attribute currentAttribute = container.getCurrentAttribute();
        TLV tlv = container.getCurrentTLV();
        try {
            if (tlv.getLength() == 0) {
                currentAttribute.add("");
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_05180_NULL_ATTRIBUTE_VALUE, new Object[0]));
                }
            } else if (container.isBinary(container.getCurrentAttribute().getId())) {
                byte[] value = tlv.getValue().getData();
                currentAttribute.add(new byte[][]{value});
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_05181_ATTRIBUTE_VALUE, Strings.dumpBytes(value)));
                }
            } else {
                String value = Strings.utf8ToString(tlv.getValue().getData());
                currentAttribute.add(value);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_05181_ATTRIBUTE_VALUE, value));
                }
            }
        }
        catch (LdapException ldapException) {
            // empty catch block
        }
        container.setGrammarEndAllowed(true);
    }
}

