/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.actions.request.search;

import org.apache.hadoop.shaded.org.apache.directory.api.asn1.DecoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.LongDecoder;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.LongDecoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreSearchRequestSizeLimit
extends GrammarAction<LdapMessageContainer<SearchRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSearchRequestSizeLimit.class);

    public StoreSearchRequestSizeLimit() {
        super("Store SearchRequest sizeLimit");
    }

    @Override
    public void action(LdapMessageContainer<SearchRequest> container) throws DecoderException {
        SearchRequest searchRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        BerValue value = tlv.getValue();
        try {
            long sizeLimit = LongDecoder.parse(value, 0L, Integer.MAX_VALUE);
            searchRequest.setSizeLimit(sizeLimit);
        }
        catch (LongDecoderException lde) {
            String msg = I18n.err(I18n.ERR_05151_BAD_SIZE_LIMIT, value.toString());
            LOG.error(msg);
            throw new DecoderException(msg, lde);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_05163_SIZE_LIMIT_SET_TO, searchRequest.getSizeLimit()));
        }
    }
}

