/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.actions.request.modify;

import org.apache.hadoop.shaded.org.apache.directory.api.asn1.DecoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreOperationType
extends GrammarAction<LdapMessageContainer<ModifyRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreOperationType.class);

    public StoreOperationType() {
        super("Store Modify request operation type");
    }

    @Override
    public void action(LdapMessageContainer<ModifyRequest> container) throws DecoderException {
        ModifyRequest modifyRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        int operation = 0;
        try {
            operation = IntegerDecoder.parse(tlv.getValue(), ModificationOperation.ADD_ATTRIBUTE.getValue(), ModificationOperation.INCREMENT_ATTRIBUTE.getValue());
            DefaultModification modification = new DefaultModification();
            modification.setOperation(operation);
            modifyRequest.addModification(modification);
            container.setCurrentModification(modification);
        }
        catch (IntegerDecoderException ide) {
            String msg = I18n.err(I18n.ERR_05124_INVALID_OPERATION, Strings.dumpBytes(tlv.getValue().getData()));
            LOG.error(msg);
            throw new DecoderException(msg, ide);
        }
        if (LOG.isDebugEnabled()) {
            switch (operation) {
                case 0: {
                    LOG.debug(I18n.msg(I18n.MSG_05133_MODIFY_OPERATION, "ADD"));
                    break;
                }
                case 1: {
                    LOG.debug(I18n.msg(I18n.MSG_05133_MODIFY_OPERATION, "DELETE"));
                    break;
                }
                case 2: {
                    LOG.debug(I18n.msg(I18n.MSG_05133_MODIFY_OPERATION, "REPLACE"));
                    break;
                }
                default: {
                    LOG.debug(I18n.msg(I18n.MSG_05133_MODIFY_OPERATION, "UNKNOWN"));
                }
            }
        }
    }
}

