/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv;

import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.BooleanDecoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BooleanDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(BooleanDecoder.class);

    private BooleanDecoder() {
    }

    public static boolean parse(BerValue value) throws BooleanDecoderException {
        byte[] bytes = value.getData();
        if (Strings.isEmpty(bytes)) {
            throw new BooleanDecoderException(I18n.err(I18n.ERR_01302_0_BYTES_LONG_BOOLEAN, new Object[0]));
        }
        if (bytes.length != 1) {
            throw new BooleanDecoderException(I18n.err(I18n.ERR_01303_N_BYTES_LONG_BOOLEAN, new Object[0]));
        }
        if (bytes[0] != 0 && bytes[0] != -1 && LOG.isWarnEnabled()) {
            LOG.warn(I18n.msg(I18n.MSG_01300_BOOLEAN_0X00_0XFF, new Object[0]));
        }
        return bytes[0] != 0;
    }
}

