/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.util;

import com.google.common.base.Preconditions;

public class PackedPartitionId {
    static final int MAXIMUM_PARTITION_ID = 0xFFFFFF;
    static final int MAXIMUM_ATTEMPT_ID = 255;
    static final int MASK_INT_LOWER_24_BITS = 0xFFFFFF;

    public static int packedPartitionId(int partitionRawId, int attemptId) {
        Preconditions.checkArgument((partitionRawId <= 0xFFFFFF ? 1 : 0) != 0, (Object)("packedPartitionId called with invalid partitionRawId: " + partitionRawId));
        Preconditions.checkArgument((attemptId <= 255 ? 1 : 0) != 0, (Object)("packedPartitionId called with invalid attemptId: " + attemptId));
        return attemptId << 24 | partitionRawId;
    }

    public static int getRawPartitionId(int packedPartitionId) {
        return packedPartitionId & 0xFFFFFF;
    }

    public static int getAttemptId(int packedPartitionId) {
        return packedPartitionId >>> 24;
    }
}

