/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.util;

import org.apache.celeborn.common.CelebornConf;

public class TransportConf {
    private final CelebornConf conf;
    private final String module;

    public TransportConf(String module, CelebornConf conf) {
        this.module = module;
        this.conf = conf;
    }

    public String getModuleName() {
        return this.module;
    }

    public String ioMode() {
        return this.conf.networkIoMode(this.module);
    }

    public boolean preferDirectBufs() {
        return this.conf.networkIoPreferDirectBufs(this.module);
    }

    public int connectTimeoutMs() {
        return this.conf.networkIoConnectTimeoutMs(this.module);
    }

    public int connectionTimeoutMs() {
        return this.conf.networkIoConnectionTimeoutMs(this.module);
    }

    public int numConnectionsPerPeer() {
        return this.conf.networkIoNumConnectionsPerPeer(this.module);
    }

    public int backLog() {
        return this.conf.networkIoBacklog(this.module);
    }

    public int serverThreads() {
        return this.conf.networkIoServerThreads(this.module);
    }

    public int clientThreads() {
        return this.conf.networkIoClientThreads(this.module);
    }

    public int receiveBuf() {
        return this.conf.networkIoReceiveBuf(this.module);
    }

    public int sendBuf() {
        return this.conf.networkIoSendBuf(this.module);
    }

    public int maxIORetries() {
        return this.conf.networkIoMaxRetries(this.module);
    }

    public int ioRetryWaitTimeMs() {
        return this.conf.networkIoRetryWaitMs(this.module);
    }

    public int memoryMapBytes() {
        return this.conf.networkIoMemoryMapBytes(this.module);
    }

    public boolean lazyFileDescriptor() {
        return this.conf.networkIoLazyFileDescriptor(this.module);
    }

    public boolean verboseMetrics() {
        return this.conf.networkIoVerboseMetrics(this.module);
    }

    public long maxChunksBeingTransferred() {
        return this.conf.networkIoMaxChunksBeingTransferred(this.module);
    }

    public String decoderMode() {
        return this.conf.networkIoDecoderMode(this.module);
    }
}

